/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.importing.TopLevelModuleFactory;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.util.ToolWindows;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewProjectSetup {
    public static final ProjectType ANDROID_PROJECT_TYPE = new ProjectType("Android");
    @NotNull
    private final TopLevelModuleFactory myTopLevelModuleFactory;

    public NewProjectSetup() {
        this(new TopLevelModuleFactory(IdeInfo.getInstance(), IdeSdks.getInstance()));
    }

    @VisibleForTesting
    NewProjectSetup(@NotNull TopLevelModuleFactory topLevelModuleFactory) {
        this.myTopLevelModuleFactory = topLevelModuleFactory;
    }

    @NotNull
    public Project createProject(@NotNull String projectName, @NotNull String projectPath) {
        ProjectManager projectManager = ProjectManager.getInstance();
        Project newProject = projectManager.createProject(projectName, projectPath);
        if (newProject == null) {
            throw new NullPointerException("Failed to create a new project");
        }
        return newProject;
    }

    void prepareProjectForImport(@NotNull Project project, @Nullable LanguageLevel languageLevel) {
        this.openProjectAndActivateProjectView(project);
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            LanguageLevelProjectExtension extension;
            if (languageLevel != null && (extension = LanguageLevelProjectExtension.getInstance((Project)project)) != null) {
                extension.setLanguageLevel(languageLevel);
            }
            File compilerOutputFolderPath = new File(Projects.getBaseDirPath((Project)project), FileUtil.join((String[])new String[]{"build", "classes"}));
            String compilerOutputFolderUrl = FilePaths.pathToIdeaUrl((File)compilerOutputFolderPath);
            CompilerProjectExtension compilerProjectExt = CompilerProjectExtension.getInstance((Project)project);
            assert (compilerProjectExt != null);
            compilerProjectExt.setCompilerOutputUrl(compilerOutputFolderUrl);
            ProjectTypeService.setProjectType((Project)project, (ProjectType)ANDROID_PROJECT_TYPE);
        }), null, null);
    }

    private void openProjectAndActivateProjectView(@NotNull Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> this.myTopLevelModuleFactory.createTopLevelModule(project));
        GradleProjects.open(project);
        ToolWindows.activateProjectView(project);
    }
}

