/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.sdk.IdeSdks;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

class TopLevelModuleFactory {
    private static final Logger LOG = Logger.getInstance(TopLevelModuleFactory.class);
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final IdeSdks myIdeSdks;

    TopLevelModuleFactory(@NotNull IdeInfo ideInfo, @NotNull IdeSdks ideSdks) {
        this.myIdeInfo = ideInfo;
        this.myIdeSdks = ideSdks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createTopLevelModule(@NotNull Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        File projectRootDir = Projects.getBaseDirPath((Project)project);
        VirtualFile contentRoot = VfsUtil.findFileByIoFile((File)projectRootDir, (boolean)true);
        if (contentRoot != null) {
            Sdk jdk;
            File moduleFile = new File(projectRootDir, projectRootDir.getName() + ".iml");
            ModifiableModuleModel projectModifieableModel = moduleManager.getModifiableModel();
            Module module = projectModifieableModel.newModule(moduleFile.getPath(), StdModuleTypes.JAVA.getId());
            try {
                if (!module.getName().equals(project.getName())) {
                    projectModifieableModel.renameModule(module, project.getName());
                }
            }
            catch (ModuleWithNameAlreadyExists ex) {
                LOG.warn(String.format("Failed to rename module '%s' to '%s'", module.getName(), project.getName()), (Throwable)ex);
            }
            projectModifieableModel.commit();
            module.setOption("external.system.id", GradleUtil.GRADLE_SYSTEM_ID.getId());
            ExternalSystemModulePropertyManager.getInstance((Module)module).setExternalOptions(GradleUtil.GRADLE_SYSTEM_ID, new ModuleData(":", GradleUtil.GRADLE_SYSTEM_ID, StdModuleTypes.JAVA.getId(), projectRootDir.getName(), projectRootDir.getPath(), projectRootDir.getPath()), new ProjectData(GradleUtil.GRADLE_SYSTEM_ID, project.getName(), project.getBasePath(), project.getBasePath()));
            ModifiableRootModel model2 = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            model2.addContentEntry(contentRoot);
            if (this.myIdeInfo.isAndroidStudio() && (jdk = this.myIdeSdks.getJdk()) != null) {
                model2.setSdk(jdk);
            }
            model2.commit();
            FacetManager facetManager = FacetManager.getInstance((Module)module);
            ModifiableFacetModel facetModel = facetManager.createModifiableModel();
            try {
                GradleFacet gradleFacet = GradleFacet.getInstance(module);
                if (gradleFacet == null) {
                    gradleFacet = (GradleFacet)facetManager.createFacet((FacetType)GradleFacet.getFacetType(), GradleFacet.getFacetName(), null);
                    facetModel.addFacet((Facet)gradleFacet);
                }
                ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH = ":";
            }
            finally {
                facetModel.commit();
            }
        }
    }
}

