/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.builder.model.AaptOptions;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaCompileOptions;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.TestOptions;
import com.android.builder.model.Variant;
import com.android.ide.common.gradle.model.GradleModelConverterUtil;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeAndroidProjectImpl;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.gradle.model.level2.IdeDependencies;
import com.android.ide.common.gradle.model.level2.IdeDependenciesFactory;
import com.android.ide.common.repository.GradleVersion;
import com.android.projectmodel.DynamicResourceValue;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.databinding.DataBindingMode;
import com.android.tools.idea.gradle.AndroidGradleClassJarProvider;
import com.android.tools.idea.gradle.project.build.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.project.model.AndroidModelFeatures;
import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlyProjectModels;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.ClassJarProvider;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Desugaring;
import com.android.tools.lint.detector.api.Lint;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class AndroidModuleModel
implements AndroidModel,
ModuleModel {
    private static final long serialVersionUID = 4L;
    private static final String[] TEST_ARTIFACT_NAMES = new String[]{"_unit_test_", "_android_test_"};
    private static final AndroidVersion NOT_SPECIFIED = new AndroidVersion(0, null);
    @NotNull
    private ProjectSystemId myProjectSystemId;
    @NotNull
    private String myModuleName;
    @NotNull
    private File myRootDirPath;
    @NotNull
    private IdeAndroidProject myAndroidProject;
    @NotNull
    private transient AndroidModelFeatures myFeatures;
    @Nullable
    private transient GradleVersion myModelVersion;
    @NotNull
    private String mySelectedVariantName;
    private transient VirtualFile myRootDir;
    @Nullable
    private Boolean myOverridesManifestPackage;
    @Nullable
    private transient AndroidVersion myMinSdkVersion;
    @NotNull
    private Map<String, BuildTypeContainer> myBuildTypesByName = new HashMap<String, BuildTypeContainer>();
    @NotNull
    private Map<String, ProductFlavorContainer> myProductFlavorsByName = new HashMap<String, ProductFlavorContainer>();
    @NotNull
    private Map<String, IdeVariant> myVariantsByName = new HashMap<String, IdeVariant>();
    @NotNull
    private Set<String> myVariantNames = new HashSet<String>();
    private boolean myUsingSingleVariantSync;
    @NotNull
    private Set<File> myExtraGeneratedSourceFolders = new HashSet<File>();

    @Nullable
    public static AndroidModuleModel get(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null ? AndroidModuleModel.get(facet) : null;
    }

    @Nullable
    public static AndroidModuleModel get(@NotNull AndroidFacet androidFacet) {
        AndroidModel androidModel = ((AndroidFacetConfiguration)androidFacet.getConfiguration()).getModel();
        return androidModel instanceof AndroidModuleModel ? (AndroidModuleModel)androidModel : null;
    }

    public AndroidModuleModel(@NotNull String moduleName, @NotNull File rootDirPath, @NotNull AndroidProject androidProject, @NotNull String selectedVariantName, @NotNull IdeDependenciesFactory dependenciesFactory) {
        this(moduleName, rootDirPath, androidProject, selectedVariantName, dependenciesFactory, null);
    }

    public AndroidModuleModel(@NotNull String moduleName, @NotNull File rootDirPath, @NotNull AndroidProject androidProject, @NotNull String variantName, @NotNull IdeDependenciesFactory dependenciesFactory, @Nullable Collection<Variant> variantsToAdd) {
        this.myAndroidProject = new IdeAndroidProjectImpl(androidProject, dependenciesFactory, variantsToAdd);
        this.myUsingSingleVariantSync = variantsToAdd != null;
        this.myProjectSystemId = GradleUtil.GRADLE_SYSTEM_ID;
        this.myModuleName = moduleName;
        this.myRootDirPath = rootDirPath;
        this.parseAndSetModelVersion();
        this.myFeatures = new AndroidModelFeatures(this.myModelVersion);
        this.populateBuildTypesByName();
        this.populateProductFlavorsByName();
        this.populateVariantsByName();
        this.mySelectedVariantName = this.findVariantToSelect(variantName);
    }

    private void populateBuildTypesByName() {
        for (BuildTypeContainer container : this.myAndroidProject.getBuildTypes()) {
            String name = container.getBuildType().getName();
            this.myBuildTypesByName.put(name, container);
        }
    }

    private void populateProductFlavorsByName() {
        for (ProductFlavorContainer container : this.myAndroidProject.getProductFlavors()) {
            String name = container.getProductFlavor().getName();
            this.myProductFlavorsByName.put(name, container);
        }
    }

    private void populateVariantsByName() {
        this.myAndroidProject.forEachVariant(variant -> this.myVariantsByName.put(variant.getName(), (IdeVariant)variant));
        this.myVariantNames = this.myUsingSingleVariantSync ? new HashSet<String>(this.myAndroidProject.getVariantNames()) : new HashSet<String>(this.myVariantsByName.keySet());
    }

    public void addVariantOnlyModuleModel(@NotNull VariantOnlyProjectModels.VariantOnlyModuleModel moduleModel, @NotNull IdeDependenciesFactory factory) {
        this.myAndroidProject.addVariants(moduleModel.getVariants(), factory);
        this.myAndroidProject.addSyncIssues(moduleModel.getAndroidProject().getSyncIssues());
        this.populateVariantsByName();
    }

    @Deprecated
    @NotNull
    public Dependencies getSelectedMainCompileDependencies() {
        IdeAndroidArtifact mainArtifact = this.getMainArtifact();
        return mainArtifact.getDependencies();
    }

    @NotNull
    public IdeDependencies getSelectedMainCompileLevel2Dependencies() {
        IdeAndroidArtifact mainArtifact = this.getMainArtifact();
        return mainArtifact.getLevel2Dependencies();
    }

    @Nullable
    public IdeDependencies getSelectedAndroidTestCompileDependencies() {
        IdeAndroidArtifact androidTestArtifact = this.getSelectedVariant().getAndroidTestArtifact();
        if (androidTestArtifact == null) {
            return null;
        }
        return androidTestArtifact.getLevel2Dependencies();
    }

    @NotNull
    public AndroidModelFeatures getFeatures() {
        return this.myFeatures;
    }

    @Nullable
    public GradleVersion getModelVersion() {
        return this.myModelVersion;
    }

    @NotNull
    public IdeAndroidArtifact getMainArtifact() {
        return this.getSelectedVariant().getMainArtifact();
    }

    @Override
    @NotNull
    public SourceProvider getDefaultSourceProvider() {
        return this.getAndroidProject().getDefaultConfig().getSourceProvider();
    }

    @Override
    @NotNull
    public List<SourceProvider> getActiveSourceProviders() {
        return this.getMainSourceProviders(this.mySelectedVariantName);
    }

    @NotNull
    private List<SourceProvider> getMainSourceProviders(@NotNull String variantName) {
        Variant variant = (Variant)this.myVariantsByName.get(variantName);
        if (variant == null) {
            AndroidModuleModel.getLogger().error("Unknown variant name '" + variantName + "' found in the module '" + this.myModuleName + "'");
            return ImmutableList.of();
        }
        ArrayList<SourceProvider> providers = new ArrayList<SourceProvider>();
        providers.add(this.getDefaultSourceProvider());
        for (String flavor : variant.getProductFlavors()) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.add(productFlavor.getSourceProvider());
        }
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        SourceProvider multiFlavorProvider = mainArtifact.getMultiFlavorSourceProvider();
        if (multiFlavorProvider != null) {
            providers.add(multiFlavorProvider);
        }
        BuildTypeContainer buildType = this.findBuildType(variant.getBuildType());
        assert (buildType != null);
        providers.add(buildType.getSourceProvider());
        SourceProvider variantProvider = mainArtifact.getVariantSourceProvider();
        if (variantProvider != null) {
            providers.add(variantProvider);
        }
        return providers;
    }

    @NotNull
    public Collection<SourceProvider> getTestSourceProviders(@NotNull Iterable<SourceProviderContainer> containers) {
        return AndroidModuleModel.getSourceProvidersForArtifacts(containers, TEST_ARTIFACT_NAMES);
    }

    @Override
    @NotNull
    public List<SourceProvider> getTestSourceProviders() {
        return this.getTestSourceProviders(this.mySelectedVariantName, TEST_ARTIFACT_NAMES);
    }

    @NotNull
    public List<SourceProvider> getTestSourceProviders(@NotNull String artifactName) {
        return this.getTestSourceProviders(this.mySelectedVariantName, artifactName);
    }

    @NotNull
    private List<SourceProvider> getTestSourceProviders(@NotNull String variantName, String ... testArtifactNames) {
        AndroidModuleModel.validateTestArtifactNames(testArtifactNames);
        Collection extraSourceProviders = this.getAndroidProject().getDefaultConfig().getExtraSourceProviders();
        ArrayList<SourceProvider> providers = new ArrayList<SourceProvider>(AndroidModuleModel.getSourceProvidersForArtifacts(extraSourceProviders, testArtifactNames));
        Variant variant = (Variant)this.myVariantsByName.get(variantName);
        assert (variant != null);
        for (String flavor : variant.getProductFlavors()) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.addAll(AndroidModuleModel.getSourceProvidersForArtifacts(productFlavor.getExtraSourceProviders(), testArtifactNames));
        }
        BuildTypeContainer buildType = this.findBuildType(variant.getBuildType());
        assert (buildType != null);
        providers.addAll(AndroidModuleModel.getSourceProvidersForArtifacts(buildType.getExtraSourceProviders(), testArtifactNames));
        return providers;
    }

    private static void validateTestArtifactNames(@NotNull String[] testArtifactNames) {
        for (String name : testArtifactNames) {
            if (AndroidModuleModel.isTestArtifact(name)) continue;
            String msg = String.format("'%1$s' is not a test artifact", name);
            throw new IllegalArgumentException(msg);
        }
    }

    private static boolean isTestArtifact(@Nullable String artifactName) {
        return ArrayUtil.contains((String)artifactName, (String[])TEST_ARTIFACT_NAMES);
    }

    public boolean variantExists(@NotNull String variantName) {
        for (Variant variant : this.myAndroidProject.getVariants()) {
            if (!variantName.equals(variant.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<SourceProvider> getAllSourceProviders() {
        Collection variants = this.myAndroidProject.getVariants();
        ArrayList<SourceProvider> providers = new ArrayList<SourceProvider>();
        providers.add(this.getDefaultSourceProvider());
        Collection flavors = this.myAndroidProject.getProductFlavors();
        for (ProductFlavorContainer flavorContainer : flavors) {
            providers.add(flavorContainer.getSourceProvider());
        }
        for (Variant variant : variants) {
            SourceProvider provider = variant.getMainArtifact().getMultiFlavorSourceProvider();
            if (provider == null) continue;
            providers.add(provider);
        }
        Collection buildTypes = this.myAndroidProject.getBuildTypes();
        for (BuildTypeContainer btc : buildTypes) {
            providers.add(btc.getSourceProvider());
        }
        for (Variant variant : variants) {
            SourceProvider provider = variant.getMainArtifact().getVariantSourceProvider();
            if (provider == null) continue;
            providers.add(provider);
        }
        return providers;
    }

    @Override
    @NotNull
    public String getApplicationId() {
        return this.getSelectedVariant().getMainArtifact().getApplicationId();
    }

    @Override
    @NotNull
    public Set<String> getAllApplicationIds() {
        HashSet<String> ids = new HashSet<String>();
        for (Variant variant : this.myAndroidProject.getVariants()) {
            String applicationId2 = variant.getMergedFlavor().getApplicationId();
            if (applicationId2 == null) continue;
            ids.add(applicationId2);
        }
        return ids;
    }

    @Override
    public Boolean isDebuggable() {
        BuildTypeContainer buildTypeContainer = this.findBuildType(this.getSelectedVariant().getBuildType());
        if (buildTypeContainer != null) {
            return buildTypeContainer.getBuildType().isDebuggable();
        }
        return null;
    }

    @Override
    @Nullable
    public AndroidVersion getMinSdkVersion() {
        if (this.myMinSdkVersion == null) {
            ApiVersion minSdkVersion2 = this.getSelectedVariant().getMergedFlavor().getMinSdkVersion();
            if (minSdkVersion2 != null && minSdkVersion2.getCodename() != null) {
                ApiVersion defaultConfigVersion = this.getAndroidProject().getDefaultConfig().getProductFlavor().getMinSdkVersion();
                if (defaultConfigVersion != null) {
                    minSdkVersion2 = defaultConfigVersion;
                }
                List flavors = this.getSelectedVariant().getProductFlavors();
                for (String flavor : flavors) {
                    ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
                    assert (productFlavor != null);
                    ApiVersion flavorVersion = productFlavor.getProductFlavor().getMinSdkVersion();
                    if (flavorVersion == null) continue;
                    minSdkVersion2 = flavorVersion;
                    break;
                }
            }
            this.myMinSdkVersion = minSdkVersion2 != null ? Lint.convertVersion((ApiVersion)minSdkVersion2, null) : NOT_SPECIFIED;
        }
        return this.myMinSdkVersion != NOT_SPECIFIED ? this.myMinSdkVersion : null;
    }

    @Override
    @Nullable
    public AndroidVersion getRuntimeMinSdkVersion() {
        ApiVersion minSdkVersion2 = this.getSelectedVariant().getMergedFlavor().getMinSdkVersion();
        return minSdkVersion2 != null ? Lint.convertVersion((ApiVersion)minSdkVersion2, null) : null;
    }

    @Override
    @Nullable
    public AndroidVersion getTargetSdkVersion() {
        ApiVersion targetSdkVersion2 = this.getSelectedVariant().getMergedFlavor().getTargetSdkVersion();
        return targetSdkVersion2 != null ? Lint.convertVersion((ApiVersion)targetSdkVersion2, null) : null;
    }

    @Override
    @Nullable
    public Integer getVersionCode() {
        IdeVariant variant = this.getSelectedVariant();
        ProductFlavor flavor = variant.getMergedFlavor();
        return flavor.getVersionCode();
    }

    @NotNull
    public ProjectSystemId getProjectSystemId() {
        return this.myProjectSystemId;
    }

    @Nullable
    public BuildTypeContainer findBuildType(@NotNull String name) {
        return this.myBuildTypesByName.get(name);
    }

    @NotNull
    public Set<String> getBuildTypes() {
        return this.myBuildTypesByName.keySet();
    }

    @NotNull
    public Set<String> getProductFlavors() {
        return this.myProductFlavorsByName.keySet();
    }

    @Nullable
    public ProductFlavorContainer findProductFlavor(@NotNull String name) {
        return this.myProductFlavorsByName.get(name);
    }

    @Override
    @NotNull
    public String getModuleName() {
        return this.myModuleName;
    }

    @Override
    @NotNull
    public File getRootDirPath() {
        return this.myRootDirPath;
    }

    @Override
    @NotNull
    public VirtualFile getRootDir() {
        if (this.myRootDir == null) {
            VirtualFile found = VfsUtil.findFileByIoFile((File)this.myRootDirPath, (boolean)true);
            assert (found != null);
            this.myRootDir = found;
        }
        return this.myRootDir;
    }

    @Override
    public boolean isGenerated(@NotNull VirtualFile file) {
        VirtualFile buildFolder = VfsUtil.findFileByIoFile((File)this.myAndroidProject.getBuildFolder(), (boolean)false);
        return buildFolder != null && VfsUtilCore.isAncestor((VirtualFile)buildFolder, (VirtualFile)file, (boolean)false);
    }

    @NotNull
    public IdeAndroidProject getAndroidProject() {
        return this.myAndroidProject;
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(AndroidModuleModel.class);
    }

    @NotNull
    public IdeVariant getSelectedVariant() {
        IdeVariant selected = this.myVariantsByName.get(this.mySelectedVariantName);
        assert (selected != null);
        return selected;
    }

    @Nullable
    public Variant findVariantByName(@NotNull String variantName) {
        return (Variant)this.myVariantsByName.get(variantName);
    }

    public void setSelectedVariantName(@NotNull String name) {
        this.mySelectedVariantName = this.findVariantToSelect(name);
        this.myOverridesManifestPackage = null;
        this.myMinSdkVersion = null;
    }

    @VisibleForTesting
    @NotNull
    String findVariantToSelect(@NotNull String variantName) {
        String newVariantName;
        if (this.myVariantsByName.containsKey(variantName)) {
            newVariantName = variantName;
        } else {
            ArrayList<String> sorted = new ArrayList<String>(this.myVariantsByName.keySet());
            Collections.sort(sorted);
            assert (!this.myVariantsByName.isEmpty()) : "There is no variant model in AndroidModuleModel!";
            newVariantName = (String)sorted.get(0);
        }
        return newVariantName;
    }

    @NotNull
    private static Collection<SourceProvider> getSourceProvidersForArtifacts(@NotNull Iterable<SourceProviderContainer> containers, String ... artifactNames) {
        LinkedHashSet<SourceProvider> providers = new LinkedHashSet<SourceProvider>();
        block0: for (SourceProviderContainer container : containers) {
            for (String artifactName : artifactNames) {
                if (!artifactName.equals(container.getArtifactName())) continue;
                providers.add(container.getSourceProvider());
                continue block0;
            }
        }
        return providers;
    }

    @NotNull
    public Collection<String> getBuildTypeNames() {
        return this.myBuildTypesByName.keySet();
    }

    @NotNull
    public Collection<String> getProductFlavorNames() {
        return this.myProductFlavorsByName.keySet();
    }

    @NotNull
    public Collection<String> getVariantNames() {
        return this.myVariantNames;
    }

    @Nullable
    public LanguageLevel getJavaLanguageLevel() {
        JavaCompileOptions compileOptions = this.myAndroidProject.getJavaCompileOptions();
        String sourceCompatibility2 = compileOptions.getSourceCompatibility();
        return LanguageLevel.parse((String)sourceCompatibility2);
    }

    @Override
    public boolean overridesManifestPackage() {
        if (this.myOverridesManifestPackage == null) {
            this.myOverridesManifestPackage = this.getAndroidProject().getDefaultConfig().getProductFlavor().getApplicationId() != null;
            IdeVariant variant = this.getSelectedVariant();
            List flavors = variant.getProductFlavors();
            for (String flavor : flavors) {
                ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
                assert (productFlavor != null);
                if (productFlavor.getProductFlavor().getApplicationId() == null) continue;
                this.myOverridesManifestPackage = true;
                break;
            }
        }
        return this.myOverridesManifestPackage;
    }

    public void registerExtraGeneratedSourceFolder(@NotNull File folderPath) {
        this.myExtraGeneratedSourceFolders.add(folderPath);
    }

    @NotNull
    public File[] getExtraGeneratedSourceFolderPaths() {
        return this.myExtraGeneratedSourceFolders.toArray(new File[0]);
    }

    @Nullable
    public Collection<SyncIssue> getSyncIssues() {
        if (this.getFeatures().isIssueReportingSupported()) {
            return this.myAndroidProject.getSyncIssues();
        }
        return null;
    }

    @Nullable
    public IdeAndroidArtifact getArtifactForAndroidTest() {
        return this.getAndroidProject().getProjectType() == 2 ? this.getSelectedVariant().getMainArtifact() : this.getSelectedVariant().getAndroidTestArtifact();
    }

    @Nullable
    public TestOptions.Execution getTestExecutionStrategy() {
        TestOptions testOptions;
        IdeAndroidArtifact artifact = this.getArtifactForAndroidTest();
        if (artifact != null && (testOptions = artifact.getTestOptions()) != null) {
            return testOptions.getExecution();
        }
        return null;
    }

    @VisibleForTesting
    boolean isUsingSingleVariantSync() {
        return this.myUsingSingleVariantSync;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.myProjectSystemId);
        out.writeObject(this.myModuleName);
        out.writeObject(this.myRootDirPath);
        out.writeObject(this.myAndroidProject);
        out.writeObject(this.mySelectedVariantName);
        out.writeBoolean(this.myUsingSingleVariantSync);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.myProjectSystemId = (ProjectSystemId)in.readObject();
        this.myModuleName = (String)in.readObject();
        this.myRootDirPath = (File)in.readObject();
        this.myAndroidProject = (IdeAndroidProject)in.readObject();
        String variantName = (String)in.readObject();
        this.myUsingSingleVariantSync = in.readBoolean();
        this.parseAndSetModelVersion();
        this.myFeatures = new AndroidModelFeatures(this.myModelVersion);
        this.myBuildTypesByName = new HashMap<String, BuildTypeContainer>();
        this.myProductFlavorsByName = new HashMap<String, ProductFlavorContainer>();
        this.myVariantsByName = new HashMap<String, IdeVariant>();
        this.myExtraGeneratedSourceFolders = new HashSet<File>();
        this.populateBuildTypesByName();
        this.populateProductFlavorsByName();
        this.populateVariantsByName();
        this.setSelectedVariantName(variantName);
    }

    private void parseAndSetModelVersion() {
        this.myModelVersion = GradleVersion.tryParse((String)this.myAndroidProject.getModelVersion());
    }

    @NotNull
    public SourceProvider getBuildTypeSourceProvider() {
        IdeVariant selectedVariant = this.getSelectedVariant();
        BuildTypeContainer buildType = this.findBuildType(selectedVariant.getBuildType());
        assert (buildType != null);
        return buildType.getSourceProvider();
    }

    @NotNull
    public List<SourceProvider> getFlavorSourceProviders() {
        IdeVariant selectedVariant = this.getSelectedVariant();
        List productFlavors = selectedVariant.getProductFlavors();
        ArrayList<SourceProvider> providers = new ArrayList<SourceProvider>();
        for (String flavor : productFlavors) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.add(productFlavor.getSourceProvider());
        }
        return providers;
    }

    public void syncSelectedVariantAndTestArtifact(@NotNull AndroidFacet facet) {
        IdeVariant variant = this.getSelectedVariant();
        JpsAndroidModuleProperties state = facet.getProperties();
        state.SELECTED_BUILD_VARIANT = variant.getName();
        IdeAndroidArtifact mainArtifact = variant.getMainArtifact();
        AndroidModuleModel.updateGradleTaskNames(state, mainArtifact);
    }

    private static void updateGradleTaskNames(@NotNull JpsAndroidModuleProperties state, @NotNull IdeAndroidArtifact mainArtifact) {
        state.ASSEMBLE_TASK_NAME = mainArtifact.getAssembleTaskName();
        state.COMPILE_JAVA_TASK_NAME = mainArtifact.getCompileTaskName();
        state.AFTER_SYNC_TASK_NAMES = new HashSet(mainArtifact.getIdeSetupTaskNames());
        state.ASSEMBLE_TEST_TASK_NAME = "";
        state.COMPILE_JAVA_TEST_TASK_NAME = "";
    }

    @Nullable
    public SourceProvider getMultiFlavorSourceProvider() {
        IdeAndroidArtifact mainArtifact = this.getSelectedVariant().getMainArtifact();
        return mainArtifact.getMultiFlavorSourceProvider();
    }

    @Nullable
    public SourceProvider getVariantSourceProvider() {
        IdeAndroidArtifact mainArtifact = this.getSelectedVariant().getMainArtifact();
        return mainArtifact.getVariantSourceProvider();
    }

    @Override
    @NotNull
    public DataBindingMode getDataBindingMode() {
        if (GradleUtil.dependsOn(this, "androidx.databinding:databinding-runtime")) {
            return DataBindingMode.ANDROIDX;
        }
        if (GradleUtil.dependsOn(this, "com.android.databinding:library")) {
            return DataBindingMode.SUPPORT;
        }
        return DataBindingMode.NONE;
    }

    @Override
    @NotNull
    public ClassJarProvider getClassJarProvider() {
        return new AndroidGradleClassJarProvider();
    }

    @Override
    public boolean isClassFileOutOfDate(@NotNull Module module, @NotNull String fqcn, @NotNull VirtualFile classFile) {
        return AndroidModuleModel.testIsClassFileOutOfDate(module, fqcn, classFile);
    }

    public static boolean testIsClassFileOutOfDate(@NotNull Module module, @NotNull String fqcn, @NotNull VirtualFile classFile) {
        Project project = module.getProject();
        GlobalSearchScope scope = module.getModuleWithDependenciesScope();
        VirtualFile sourceFile = (VirtualFile)ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(fqcn, scope);
            if (psiClass == null) {
                return null;
            }
            PsiFile psiFile = psiClass.getContainingFile();
            if (psiFile == null) {
                return null;
            }
            return psiFile.getVirtualFile();
        });
        if (sourceFile == null) {
            return false;
        }
        if (FileDocumentManager.getInstance().isFileModified(sourceFile)) {
            return true;
        }
        long sourceFileModified = sourceFile.getTimeStamp();
        long lastBuildTimestamp = classFile.getTimeStamp();
        Long projectBuildTimestamp = PostProjectBuildTasksExecutor.getInstance(project).getLastBuildTimestamp();
        if (projectBuildTimestamp != null) {
            lastBuildTimestamp = projectBuildTimestamp;
        }
        return sourceFileModified > lastBuildTimestamp && lastBuildTimestamp > 0L;
    }

    @Override
    @NotNull
    public AaptOptions.Namespacing getNamespacing() {
        return this.myAndroidProject.getAaptOptions().getNamespacing();
    }

    @Override
    @NotNull
    public Set<Desugaring> getDesugaring() {
        GradleVersion version2 = this.getModelVersion();
        if (version2 == null) {
            return Desugaring.NONE;
        }
        return LintClient.getGradleDesugaring((GradleVersion)version2, (LanguageLevel)this.getJavaLanguageLevel());
    }

    @Override
    @NotNull
    public Map<String, DynamicResourceValue> getResValues() {
        IdeVariant selectedVariant = this.getSelectedVariant();
        HashMap<String, DynamicResourceValue> result2 = new HashMap<String, DynamicResourceValue>(GradleModelConverterUtil.classFieldsToDynamicResourceValues((Map)selectedVariant.getMergedFlavor().getResValues()));
        BuildTypeContainer buildType = this.findBuildType(selectedVariant.getBuildType());
        if (buildType != null) {
            result2.putAll(GradleModelConverterUtil.classFieldsToDynamicResourceValues((Map)buildType.getBuildType().getResValues()));
        }
        return result2;
    }
}

