/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleModuleModel
implements ModuleModel {
    private static final long serialVersionUID = 3L;
    @NotNull
    private final String myModuleName;
    @NotNull
    private final List<String> myTaskNames;
    @NotNull
    private final String myGradlePath;
    @NotNull
    private final File myRootFolderPath;
    @NotNull
    private final List<String> myGradlePlugins;
    @Nullable
    private final File myBuildFilePath;
    @Nullable
    private final String myGradleVersion;
    @Nullable
    private final String myAgpVersion;

    public GradleModuleModel(@NotNull String moduleName, @NotNull GradleProject gradleProject, @NotNull Collection<String> gradlePlugins, @Nullable File buildFilePath, @Nullable String gradleVersion2, @Nullable String agpVersion) {
        this(moduleName, GradleModuleModel.getTaskNames(gradleProject), gradleProject.getPath(), gradleProject.getProjectIdentifier().getBuildIdentifier().getRootDir(), (List<String>)ImmutableList.copyOf(gradlePlugins), buildFilePath, gradleVersion2, agpVersion);
    }

    @VisibleForTesting
    public GradleModuleModel(@NotNull String moduleName, @NotNull List<String> taskNames, @NotNull String gradlePath, @NotNull File rootFolderPath, @NotNull List<String> gradlePlugins, @Nullable File buildFilePath, @Nullable String gradleVersion2, @Nullable String agpVersion) {
        this.myModuleName = moduleName;
        this.myTaskNames = taskNames;
        this.myGradlePath = gradlePath;
        this.myRootFolderPath = rootFolderPath;
        this.myGradlePlugins = gradlePlugins;
        this.myBuildFilePath = buildFilePath;
        this.myGradleVersion = gradleVersion2;
        this.myAgpVersion = agpVersion;
    }

    @NotNull
    private static List<String> getTaskNames(@NotNull GradleProject gradleProject) {
        ArrayList<String> taskNames = new ArrayList<String>();
        DomainObjectSet tasks = gradleProject.getTasks();
        if (!tasks.isEmpty()) {
            for (GradleTask task : tasks) {
                String name = task.getName();
                if (!StringUtil.isNotEmpty((String)name)) continue;
                taskNames.add(task.getProject().getPath() + ":" + task.getName());
            }
        }
        return taskNames;
    }

    @Override
    @NotNull
    public String getModuleName() {
        return this.myModuleName;
    }

    @NotNull
    public String getGradlePath() {
        return this.myGradlePath;
    }

    @NotNull
    public File getRootFolderPath() {
        return this.myRootFolderPath;
    }

    @NotNull
    public List<String> getTaskNames() {
        return this.myTaskNames;
    }

    @Nullable
    public VirtualFile getBuildFile() {
        return this.myBuildFilePath != null ? VfsUtil.findFileByIoFile((File)this.myBuildFilePath, (boolean)true) : null;
    }

    @Nullable
    public File getBuildFilePath() {
        return this.myBuildFilePath;
    }

    @Nullable
    public String getGradleVersion() {
        return this.myGradleVersion;
    }

    @Nullable
    public String getAgpVersion() {
        return this.myAgpVersion;
    }

    @NotNull
    public List<String> getGradlePlugins() {
        return this.myGradlePlugins;
    }
}

