/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.model.java.IdeaJarLibraryDependencyFactory;
import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleContentRoot;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;
import org.jetbrains.plugins.gradle.tooling.internal.IdeaCompilerOutputImpl;

public class IdeaJavaModuleModelFactory {
    @NotNull
    private final IdeaJarLibraryDependencyFactory myIdeaJarLibraryDependencyFactory;

    public IdeaJavaModuleModelFactory() {
        this(new IdeaJarLibraryDependencyFactory());
    }

    IdeaJavaModuleModelFactory(@NotNull IdeaJarLibraryDependencyFactory ideaJarLibraryDependencyFactory) {
        this.myIdeaJarLibraryDependencyFactory = ideaJarLibraryDependencyFactory;
    }

    @NotNull
    public JavaModuleModel create(@NotNull IdeaModule ideaModule, @Nullable ModuleExtendedModel javaModel, @NotNull Collection<SyncIssue> syncIssues, boolean androidModuleWithoutVariants) {
        Pair<Collection<JavaModuleDependency>, Collection<JarLibraryDependency>> dependencies = this.getDependencies(ideaModule);
        return new JavaModuleModel(ideaModule.getName(), IdeaJavaModuleModelFactory.getContentRoots(ideaModule, javaModel), (Collection)dependencies.first, (Collection)dependencies.second, syncIssues, IdeaJavaModuleModelFactory.getArtifactsByConfiguration(javaModel), IdeaJavaModuleModelFactory.getCompilerOutput(javaModel), ideaModule.getGradleProject().getBuildDirectory(), IdeaJavaModuleModelFactory.getLanguageLevel(javaModel), !androidModuleWithoutVariants && JavaModuleModel.isBuildable(ideaModule.getGradleProject()), androidModuleWithoutVariants);
    }

    @NotNull
    private static ExtIdeaCompilerOutput getCompilerOutputCopy(@NotNull ExtIdeaCompilerOutput compilerOutput) {
        IdeaCompilerOutputImpl clone = new IdeaCompilerOutputImpl();
        clone.setMainClassesDir(compilerOutput.getMainClassesDir());
        clone.setMainResourcesDir(compilerOutput.getMainResourcesDir());
        clone.setTestClassesDir(compilerOutput.getTestClassesDir());
        clone.setTestResourcesDir(compilerOutput.getTestResourcesDir());
        return clone;
    }

    @Nullable
    private static ExtIdeaCompilerOutput getCompilerOutput(@Nullable ModuleExtendedModel javaModel) {
        return javaModel != null ? IdeaJavaModuleModelFactory.getCompilerOutputCopy(javaModel.getCompilerOutput()) : null;
    }

    @NotNull
    private static Collection<JavaModuleContentRoot> getContentRoots(@NotNull IdeaModule ideaModule, @Nullable ModuleExtendedModel javaModel) {
        DomainObjectSet contentRoots;
        DomainObjectSet domainObjectSet = contentRoots = javaModel != null ? javaModel.getContentRoots() : null;
        if (contentRoots == null) {
            contentRoots = ideaModule.getContentRoots();
        }
        ArrayList<JavaModuleContentRoot> javaModuleContentRoots = new ArrayList<JavaModuleContentRoot>();
        if (contentRoots != null) {
            for (IdeaContentRoot contentRoot : contentRoots) {
                if (contentRoot == null) continue;
                javaModuleContentRoots.add(JavaModuleContentRoot.copy(contentRoot));
            }
        }
        return javaModuleContentRoots;
    }

    @NotNull
    private static Map<String, Set<File>> getArtifactsByConfiguration(@Nullable ModuleExtendedModel javaModel) {
        Map<String, Set<File>> artifactsByConfiguration = Collections.emptyMap();
        if (javaModel != null) {
            artifactsByConfiguration = javaModel.getArtifactsByConfiguration();
        }
        return artifactsByConfiguration != null ? artifactsByConfiguration : Collections.emptyMap();
    }

    @NotNull
    private Pair<Collection<JavaModuleDependency>, Collection<JarLibraryDependency>> getDependencies(@NotNull IdeaModule ideaModule) {
        List dependencies = ideaModule.getDependencies().getAll();
        ArrayList<JavaModuleDependency> javaModuleDependencies = new ArrayList<JavaModuleDependency>();
        ArrayList<JarLibraryDependency> jarLibraryDependencies = new ArrayList<JarLibraryDependency>();
        if (dependencies != null) {
            for (IdeaDependency dependency : dependencies) {
                JavaModuleDependency moduleDependency;
                if (dependency instanceof IdeaSingleEntryLibraryDependency) {
                    JarLibraryDependency libraryDependency = this.myIdeaJarLibraryDependencyFactory.create((IdeaSingleEntryLibraryDependency)dependency);
                    if (libraryDependency == null) continue;
                    jarLibraryDependencies.add(libraryDependency);
                    continue;
                }
                if (!(dependency instanceof IdeaModuleDependency) || StringUtil.equalsIgnoreCase((CharSequence)dependency.getScope().getScope(), (CharSequence)"RUNTIME") || (moduleDependency = JavaModuleDependency.copy(ideaModule.getProject(), (IdeaModuleDependency)dependency)) == null) continue;
                javaModuleDependencies.add(moduleDependency);
            }
        }
        return Pair.create(javaModuleDependencies, jarLibraryDependencies);
    }

    @Nullable
    private static String getLanguageLevel(@Nullable ModuleExtendedModel javaModel) {
        return javaModel != null ? javaModel.getJavaSourceCompatibility() : null;
    }
}

