/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.SyncIssue;
import com.android.java.model.ArtifactModel;
import com.android.java.model.JavaLibrary;
import com.android.java.model.JavaProject;
import com.android.java.model.SourceSet;
import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleContentRoot;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.android.tools.idea.gradle.model.java.NewJarLibraryDependencyFactory;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.tooling.model.GradleProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;
import org.jetbrains.plugins.gradle.tooling.internal.IdeaCompilerOutputImpl;

public class JavaModuleModelFactory {
    @NotNull
    private static final String MAIN_SOURCE_SET_NAME = "main";
    @NotNull
    private static final String TEST_SOURCE_SET_NAME = "test";
    @NotNull
    private static final String COMPILE_SCOPE = "COMPILE";
    @NotNull
    private static final String TEST_SCOPE = "TEST";
    @NotNull
    private final NewJarLibraryDependencyFactory myNewJarLibraryDependencyFactory = new NewJarLibraryDependencyFactory();

    @NotNull
    public JavaModuleModel create(@NotNull File moduleFolderPath, @NotNull GradleProject gradleProject, @NotNull ArtifactModel jarAarModel) {
        Collection<JavaModuleContentRoot> contentRoots = JavaModuleModelFactory.getContentRoots(moduleFolderPath, gradleProject);
        return new JavaModuleModel(jarAarModel.getName(), contentRoots, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), jarAarModel.getArtifactsByConfiguration(), null, gradleProject.getBuildDirectory(), null, JavaModuleModel.isBuildable(gradleProject), false);
    }

    @NotNull
    private static Collection<JavaModuleContentRoot> getContentRoots(@NotNull File moduleFolderPath, @NotNull GradleProject gradleProject) {
        JavaModuleContentRoot contentRoot = new JavaModuleContentRoot(moduleFolderPath, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), JavaModuleModelFactory.getExcludedFolders(gradleProject));
        return Collections.singleton(contentRoot);
    }

    @NotNull
    private static Collection<File> getExcludedFolders(@NotNull GradleProject gradleProject) {
        return Arrays.asList(gradleProject.getBuildDirectory(), new File(gradleProject.getProjectDirectory(), ".gradle"));
    }

    @NotNull
    public JavaModuleModel create(@NotNull GradleProject gradleProject, @NotNull AndroidProject androidProject, @NotNull Collection<SyncIssue> syncIssues) {
        String sourceCompatibility2 = androidProject.getJavaCompileOptions().getSourceCompatibility();
        return new JavaModuleModel(androidProject.getName(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), syncIssues, Collections.emptyMap(), (ExtIdeaCompilerOutput)new IdeaCompilerOutputImpl(), gradleProject.getBuildDirectory(), sourceCompatibility2, false, true);
    }

    @NotNull
    public JavaModuleModel create(@NotNull File moduleFolderPath, @NotNull GradleProject gradleProject, @NotNull JavaProject javaProject) {
        Pair<Collection<JavaModuleDependency>, Collection<JarLibraryDependency>> dependencies = this.getDependencies(javaProject);
        String projectName = javaProject.getName();
        Collection<JavaModuleContentRoot> contentRoots = JavaModuleModelFactory.getContentRoots(moduleFolderPath, javaProject, gradleProject);
        return new JavaModuleModel(projectName, contentRoots, (Collection)dependencies.first, (Collection)dependencies.second, Collections.emptyList(), Collections.emptyMap(), JavaModuleModelFactory.getCompilerOutput(javaProject), gradleProject.getBuildDirectory(), javaProject.getJavaLanguageLevel(), JavaModuleModel.isBuildable(gradleProject), false);
    }

    @NotNull
    private Pair<Collection<JavaModuleDependency>, Collection<JarLibraryDependency>> getDependencies(@NotNull JavaProject javaProject) {
        ArrayList<JavaModuleDependency> javaModuleDependencies = new ArrayList<JavaModuleDependency>();
        ArrayList<JarLibraryDependency> jarLibraryDependencies = new ArrayList<JarLibraryDependency>();
        SourceSets sourceSets = new SourceSets(javaProject);
        SourceSet mainSourceSet = sourceSets.getMainSourceSet();
        SourceSet testSourceSet = sourceSets.getTestSourceSet();
        if (mainSourceSet != null && testSourceSet != null) {
            Collection dependenciesForMain = mainSourceSet.getCompileClasspathDependencies();
            Collection dependenciesForTest = testSourceSet.getRuntimeClasspathDependencies();
            ImmutableSet dependenciesForMainInSet = ImmutableSet.copyOf((Collection)dependenciesForMain);
            for (JavaLibrary library : dependenciesForMain) {
                this.createDependency(library, COMPILE_SCOPE, javaModuleDependencies, jarLibraryDependencies);
            }
            for (JavaLibrary library : dependenciesForTest) {
                if (JavaModuleModelFactory.libraryAlreadyPresent((Set<JavaLibrary>)dependenciesForMainInSet, library)) continue;
                this.createDependency(library, TEST_SCOPE, javaModuleDependencies, jarLibraryDependencies);
            }
        }
        return Pair.create(javaModuleDependencies, jarLibraryDependencies);
    }

    private static boolean libraryAlreadyPresent(@NotNull Set<JavaLibrary> set, @NotNull JavaLibrary library) {
        return set.stream().anyMatch(existing2 -> {
            if (library.getBuildId() == null || library.getProject() == null) {
                return library.equals(existing2);
            }
            return library.getBuildId().equals(existing2.getBuildId()) && library.getProject().equals(existing2.getProject());
        });
    }

    private void createDependency(@NotNull JavaLibrary javaLibrary, @NotNull String scope, @NotNull Collection<JavaModuleDependency> javaModuleDependencies, @NotNull Collection<JarLibraryDependency> jarLibraryDependencies) {
        if (javaLibrary.getProject() != null) {
            assert (javaLibrary.getBuildId() != null);
            String moduleId = Modules.createUniqueModuleId(javaLibrary.getBuildId(), javaLibrary.getProject());
            javaModuleDependencies.add(new JavaModuleDependency(javaLibrary.getName(), moduleId, scope, false));
        } else {
            JarLibraryDependency jarLibraryDependency = this.myNewJarLibraryDependencyFactory.create(javaLibrary, scope);
            if (jarLibraryDependency != null) {
                jarLibraryDependencies.add(jarLibraryDependency);
            }
        }
    }

    @NotNull
    private static ExtIdeaCompilerOutput getCompilerOutput(@NotNull JavaProject javaProject) {
        IdeaCompilerOutputImpl compilerOutput = new IdeaCompilerOutputImpl();
        SourceSets sourceSets = new SourceSets(javaProject);
        SourceSet mainSourceSet = sourceSets.getMainSourceSet();
        SourceSet testSourceSet = sourceSets.getTestSourceSet();
        if (mainSourceSet != null && testSourceSet != null) {
            Iterator classesOutputIterator = mainSourceSet.getClassesOutputDirectories().iterator();
            if (classesOutputIterator.hasNext()) {
                compilerOutput.setMainClassesDir((File)classesOutputIterator.next());
            }
            compilerOutput.setMainResourcesDir(mainSourceSet.getResourcesOutputDirectory());
            Iterator testClassesOutputIterator = testSourceSet.getClassesOutputDirectories().iterator();
            if (testClassesOutputIterator.hasNext()) {
                compilerOutput.setTestClassesDir((File)testClassesOutputIterator.next());
            }
            compilerOutput.setTestResourcesDir(testSourceSet.getResourcesOutputDirectory());
        }
        return compilerOutput;
    }

    @NotNull
    private static Collection<JavaModuleContentRoot> getContentRoots(@NotNull File moduleFolderPath, @NotNull JavaProject javaProject, @NotNull GradleProject gradleProject) {
        ArrayList<File> sourceFolderPaths = new ArrayList<File>();
        ArrayList<File> resourceFolderPaths = new ArrayList<File>();
        ArrayList<File> testFolderPaths = new ArrayList<File>();
        ArrayList<File> testResourceFolderPaths = new ArrayList<File>();
        for (SourceSet sourceSet : javaProject.getSourceSets()) {
            if (sourceSet.getName().equals(TEST_SOURCE_SET_NAME)) {
                testFolderPaths.addAll(sourceSet.getSourceDirectories());
                testResourceFolderPaths.addAll(sourceSet.getResourcesDirectories());
                continue;
            }
            sourceFolderPaths.addAll(sourceSet.getSourceDirectories());
            resourceFolderPaths.addAll(sourceSet.getResourcesDirectories());
        }
        JavaModuleContentRoot contentRoot = new JavaModuleContentRoot(moduleFolderPath, sourceFolderPaths, Collections.emptyList(), resourceFolderPaths, testFolderPaths, Collections.emptyList(), testResourceFolderPaths, JavaModuleModelFactory.getExcludedFolders(gradleProject));
        return Collections.singleton(contentRoot);
    }

    private static class SourceSets {
        @NotNull
        private final Map<String, SourceSet> mySourceSetByName;

        SourceSets(@NotNull JavaProject javaProject) {
            this.mySourceSetByName = javaProject.getSourceSets().stream().collect(Collectors.toMap(SourceSet::getName, SourceSet2 -> SourceSet2));
        }

        @Nullable
        SourceSet getMainSourceSet() {
            return this.mySourceSetByName.get(JavaModuleModelFactory.MAIN_SOURCE_SET_NAME);
        }

        @Nullable
        SourceSet getTestSourceSet() {
            return this.mySourceSetByName.get(JavaModuleModelFactory.TEST_SOURCE_SET_NAME);
        }
    }
}

