/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.NativeVariantInfo;
import com.android.ide.common.gradle.model.IdeNativeAndroidProject;
import com.android.ide.common.gradle.model.IdeNativeVariantAbi;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModelFeatures;
import com.android.tools.idea.gradle.project.model.NdkVariant;
import com.android.tools.idea.gradle.project.model.NdkVariantName;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.intellij.openapi.module.Module;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkModuleModel
implements ModuleModel {
    private static final long serialVersionUID = 4L;
    @NotNull
    private String myModuleName;
    @NotNull
    private File myRootDirPath;
    @NotNull
    private IdeNativeAndroidProject myAndroidProject;
    @NotNull
    private transient NdkModelFeatures myFeatures;
    @Nullable
    private transient GradleVersion myModelVersion;
    @NotNull
    private List<IdeNativeVariantAbi> myVariantAbi = new ArrayList<IdeNativeVariantAbi>();
    @NotNull
    private Map<String, NdkVariantName> myVariantNamesByVariantAndAbiName = new HashMap<String, NdkVariantName>();
    @NotNull
    private Map<String, NdkVariant> myVariantsByName = new HashMap<String, NdkVariant>();
    @NotNull
    private Map<String, NativeToolchain> myToolchainsByName = new HashMap<String, NativeToolchain>();
    @NotNull
    private Map<String, NativeSettings> mySettingsByName = new HashMap<String, NativeSettings>();
    @NotNull
    private String mySelectedVariantName;

    @Nullable
    public static NdkModuleModel get(@NotNull Module module) {
        NdkFacet facet = NdkFacet.getInstance(module);
        return facet != null ? NdkModuleModel.get(facet) : null;
    }

    @Nullable
    public static NdkModuleModel get(@NotNull NdkFacet ndkFacet) {
        NdkModuleModel androidModel = ndkFacet.getNdkModuleModel();
        if (androidModel == null) {
            return null;
        }
        return androidModel;
    }

    public NdkModuleModel(@NotNull String moduleName, @NotNull File rootDirPath, @NotNull IdeNativeAndroidProject androidProject, @NotNull List<IdeNativeVariantAbi> variantAbi) {
        this.myModuleName = moduleName;
        this.myRootDirPath = rootDirPath;
        this.myAndroidProject = androidProject;
        this.myVariantAbi.addAll(variantAbi);
        this.parseAndSetModelVersion();
        this.myFeatures = new NdkModelFeatures(this.myModelVersion);
        this.populateModuleFields();
        this.initializeSelectedVariant();
    }

    private void populateModuleFields() {
        if (this.myVariantAbi.isEmpty()) {
            this.populateForFullVariantsSync();
        } else {
            this.populateForSingleVariantSync();
        }
        if (this.myVariantsByName.isEmpty()) {
            this.myVariantsByName.put("------", new NdkVariant("------", this.myFeatures.isExportedHeadersSupported()));
            this.myVariantNamesByVariantAndAbiName.put("------", new NdkVariantName("---", "--"));
        }
    }

    private void populateForFullVariantsSync() {
        for (NativeArtifact artifact : this.myAndroidProject.getArtifacts()) {
            String variantName = this.myFeatures.isGroupNameSupported() ? artifact.getGroupName() : artifact.getName();
            NdkVariantName ndkVariantName = new NdkVariantName(variantName, artifact.getAbi());
            NdkVariant variant = this.myVariantsByName.get(ndkVariantName.displayName);
            if (variant == null) {
                variant = new NdkVariant(ndkVariantName.displayName, this.myFeatures.isExportedHeadersSupported());
                this.myVariantsByName.put(ndkVariantName.displayName, variant);
                this.myVariantNamesByVariantAndAbiName.put(ndkVariantName.displayName, ndkVariantName);
            }
            variant.addArtifact(artifact);
        }
        this.populateToolchains(this.myAndroidProject.getToolChains());
        this.populateSettings(this.myAndroidProject.getSettings());
    }

    private void populateForSingleVariantSync() {
        for (Map.Entry entry : this.myAndroidProject.getVariantInfos().entrySet()) {
            for (String abi : ((NativeVariantInfo)entry.getValue()).getAbiNames()) {
                NdkVariantName ndkVariantName = new NdkVariantName((String)entry.getKey(), abi);
                this.myVariantNamesByVariantAndAbiName.put(ndkVariantName.displayName, ndkVariantName);
            }
        }
        for (IdeNativeVariantAbi variantAbi : this.myVariantAbi) {
            this.populateForNativeVariantAbi(variantAbi);
        }
    }

    private void populateForNativeVariantAbi(@NotNull IdeNativeVariantAbi variantAbi) {
        String variantName = NdkModuleModel.getNdkVariantName(variantAbi.getVariantName(), variantAbi.getAbi());
        NdkVariant variant = new NdkVariant(variantName, this.myFeatures.isExportedHeadersSupported());
        for (NativeArtifact artifact : variantAbi.getArtifacts()) {
            variant.addArtifact(artifact);
        }
        this.myVariantsByName.put(variantName, variant);
        this.populateToolchains(variantAbi.getToolChains());
        this.populateSettings(variantAbi.getSettings());
    }

    private void populateToolchains(@NotNull Collection<NativeToolchain> nativeToolchains) {
        for (NativeToolchain toolchain : nativeToolchains) {
            this.myToolchainsByName.put(toolchain.getName(), toolchain);
        }
    }

    private void populateSettings(@NotNull Collection<NativeSettings> nativeSettings) {
        for (NativeSettings settings : nativeSettings) {
            this.mySettingsByName.put(settings.getName(), settings);
        }
    }

    private void initializeSelectedVariant() {
        Set<String> variantNames = this.myVariantsByName.keySet();
        assert (!variantNames.isEmpty());
        if (variantNames.size() == 1) {
            this.mySelectedVariantName = (String)Iterables.getOnlyElement(variantNames);
            return;
        }
        for (String variantName : variantNames) {
            if (!variantName.equals("debug") && !variantName.equals(NdkModuleModel.getNdkVariantName("debug", "x86"))) continue;
            this.mySelectedVariantName = variantName;
            return;
        }
        ArrayList<String> sortedVariantNames = new ArrayList<String>(variantNames);
        Collections.sort(sortedVariantNames);
        assert (!sortedVariantNames.isEmpty());
        this.mySelectedVariantName = (String)sortedVariantNames.get(0);
    }

    public void addVariantOnlyModuleModel(@NotNull IdeNativeVariantAbi variantAbi) {
        this.myVariantAbi.add(variantAbi);
        this.populateForNativeVariantAbi(variantAbi);
    }

    private void parseAndSetModelVersion() {
        this.myModelVersion = GradleVersion.tryParse((String)this.myAndroidProject.getModelVersion());
    }

    @Override
    @NotNull
    public String getModuleName() {
        return this.myModuleName;
    }

    @NotNull
    public File getRootDirPath() {
        return this.myRootDirPath;
    }

    @NotNull
    public IdeNativeAndroidProject getAndroidProject() {
        return this.myAndroidProject;
    }

    @NotNull
    public Collection<String> getNdkVariantNames() {
        return this.myVariantNamesByVariantAndAbiName.keySet();
    }

    @NotNull
    public String getVariantName(@NotNull String ndkVariantName) {
        NdkVariantName result2 = this.myVariantNamesByVariantAndAbiName.get(ndkVariantName);
        if (result2 == null) {
            throw new RuntimeException(String.format("Variant named '%s' but only variants named '%s' were found.", ndkVariantName, Joiner.on((String)",").join(this.myVariantNamesByVariantAndAbiName.keySet())));
        }
        return this.myVariantNamesByVariantAndAbiName.get((Object)ndkVariantName).variant;
    }

    @NotNull
    public String getAbiName(@NotNull String ndkVariantName) {
        return this.myVariantNamesByVariantAndAbiName.get((Object)ndkVariantName).abi;
    }

    @NotNull
    public static String getNdkVariantName(@NotNull String variant, @NotNull String abi) {
        return variant + "-" + abi;
    }

    @NotNull
    public Collection<NdkVariant> getVariants() {
        return this.myVariantsByName.values();
    }

    @NotNull
    public NdkVariant getSelectedVariant() {
        NdkVariant selected = this.myVariantsByName.get(this.mySelectedVariantName);
        assert (selected != null);
        return selected;
    }

    public boolean variantExists(@NotNull String variantName) {
        return this.myVariantsByName.containsKey(variantName);
    }

    public void setSelectedVariantName(@NotNull String name) {
        Set<String> variantNames = this.myVariantsByName.keySet();
        if (variantNames.contains(name)) {
            this.mySelectedVariantName = name;
        } else {
            this.initializeSelectedVariant();
        }
    }

    @Nullable
    public NativeToolchain findToolchain(@NotNull String toolchainName) {
        return this.myToolchainsByName.get(toolchainName);
    }

    @Nullable
    public NativeSettings findSettings(@NotNull String settingsName) {
        return this.mySettingsByName.get(settingsName);
    }

    @NotNull
    public NdkModelFeatures getFeatures() {
        return this.myFeatures;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.myModuleName);
        out.writeObject(this.myRootDirPath);
        out.writeObject(this.myAndroidProject);
        out.writeObject(this.mySelectedVariantName);
        out.writeObject(this.myVariantAbi);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.myModuleName = (String)in.readObject();
        this.myRootDirPath = (File)in.readObject();
        this.myAndroidProject = (IdeNativeAndroidProject)in.readObject();
        this.mySelectedVariantName = (String)in.readObject();
        this.myVariantAbi = (List)in.readObject();
        this.parseAndSetModelVersion();
        this.myFeatures = new NdkModelFeatures(this.myModelVersion);
        this.myVariantNamesByVariantAndAbiName = new HashMap<String, NdkVariantName>();
        this.myVariantsByName = new HashMap<String, NdkVariant>();
        this.myToolchainsByName = new HashMap<String, NativeToolchain>();
        this.mySettingsByName = new HashMap<String, NativeSettings>();
        this.populateModuleFields();
    }

    public int hashCode() {
        return Objects.hash(this.myModuleName, this.myRootDirPath, this.myAndroidProject, this.mySelectedVariantName, this.myVariantAbi);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NdkModuleModel)) {
            return false;
        }
        NdkModuleModel that = (NdkModuleModel)obj;
        if (!Objects.equals(this.myModuleName, that.myModuleName)) {
            return false;
        }
        if (!Objects.equals(this.myRootDirPath, that.myRootDirPath)) {
            return false;
        }
        if (!Objects.equals(this.myAndroidProject, that.myAndroidProject)) {
            return false;
        }
        if (!Objects.equals(this.mySelectedVariantName, that.mySelectedVariantName)) {
            return false;
        }
        return Objects.equals(this.myVariantAbi, that.myVariantAbi);
    }

    public static class DummyNdkVariant {
        private static final String variantNameWithoutAbi = "---";
        private static final String abiName = "--";
        public static final String variantNameWithAbi = "------";
    }
}

