/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NdkVariant {
    @NotNull
    private final String myVariantName;
    @NotNull
    private final Map<String, NativeArtifact> myArtifactsByName = new HashMap<String, NativeArtifact>();
    private final boolean myExportedHeadersSupported;

    NdkVariant(@NotNull String variantName, boolean exportedHeadersSupported) {
        this.myVariantName = variantName;
        this.myExportedHeadersSupported = exportedHeadersSupported;
    }

    void addArtifact(@NotNull NativeArtifact artifact) {
        this.myArtifactsByName.put(artifact.getName(), artifact);
    }

    @NotNull
    public String getName() {
        return this.myVariantName;
    }

    @NotNull
    public Collection<File> getSourceFolders() {
        LinkedHashSet<File> sourceFolders = new LinkedHashSet<File>();
        for (NativeArtifact artifact : this.getArtifacts()) {
            if (this.myExportedHeadersSupported) {
                sourceFolders.addAll(artifact.getExportedHeaders());
            }
            for (NativeFile sourceFile : artifact.getSourceFiles()) {
                File parentFile = sourceFile.getFilePath().getParentFile();
                if (parentFile == null) continue;
                sourceFolders.add(parentFile);
            }
        }
        return ImmutableList.copyOf(sourceFolders);
    }

    @NotNull
    public Collection<NativeArtifact> getArtifacts() {
        return this.myArtifactsByName.values();
    }
}

