/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.settings;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

@State(name="AndroidStudioGradleSettings", storages={@Storage(file="android.gradle.studio.xml")})
public class AndroidStudioGradleIdeSettings
implements PersistentStateComponent<AndroidStudioGradleIdeSettings> {
    public boolean ENABLE_EMBEDDED_MAVEN_REPO;
    public long EMBEDDED_MAVEN_REPO_ENABLED_TIMESTAMP_MILLIS = -1L;
    @NotNull
    private final CurrentTimeProvider myCurrentTimeProvider;

    public AndroidStudioGradleIdeSettings() {
        this(new CurrentTimeProvider());
    }

    @VisibleForTesting
    AndroidStudioGradleIdeSettings(@NotNull CurrentTimeProvider currentTimeProvider) {
        this.myCurrentTimeProvider = currentTimeProvider;
    }

    @NotNull
    public static AndroidStudioGradleIdeSettings getInstance() {
        return (AndroidStudioGradleIdeSettings)ServiceManager.getService(AndroidStudioGradleIdeSettings.class);
    }

    @NotNull
    public AndroidStudioGradleIdeSettings getState() {
        return this;
    }

    public void loadState(@NotNull AndroidStudioGradleIdeSettings state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public boolean isEmbeddedMavenRepoEnabled() {
        if (this.ENABLE_EMBEDDED_MAVEN_REPO) {
            long timePassedMillis;
            long daysPassed;
            if (this.EMBEDDED_MAVEN_REPO_ENABLED_TIMESTAMP_MILLIS == -1L) {
                this.EMBEDDED_MAVEN_REPO_ENABLED_TIMESTAMP_MILLIS = this.myCurrentTimeProvider.getCurrentTimeMillis();
            }
            this.ENABLE_EMBEDDED_MAVEN_REPO = (daysPassed = TimeUnit.MILLISECONDS.toDays(timePassedMillis = this.myCurrentTimeProvider.getCurrentTimeMillis() - this.EMBEDDED_MAVEN_REPO_ENABLED_TIMESTAMP_MILLIS)) <= 14L;
        }
        return this.ENABLE_EMBEDDED_MAVEN_REPO;
    }

    public void setEmbeddedMavenRepoEnabled(boolean value2) {
        this.ENABLE_EMBEDDED_MAVEN_REPO = value2;
        this.EMBEDDED_MAVEN_REPO_ENABLED_TIMESTAMP_MILLIS = value2 ? this.myCurrentTimeProvider.getCurrentTimeMillis() : -1L;
    }

    static class CurrentTimeProvider {
        CurrentTimeProvider() {
        }

        long getCurrentTimeMillis() {
            return System.currentTimeMillis();
        }
    }
}

