/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.google.common.collect.Lists;
import com.intellij.concurrency.JobLauncher;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.ui.EditorNotifications;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;

public class GradleFiles {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private final Set<VirtualFile> myChangedFiles = new HashSet<VirtualFile>();
    @NotNull
    private final Set<VirtualFile> myChangedExternalFiles = new HashSet<VirtualFile>();
    @NotNull
    private final Map<VirtualFile, Integer> myFileHashes = new HashMap<VirtualFile, Integer>();
    @NotNull
    private final Set<VirtualFile> myExternalBuildFiles = new HashSet<VirtualFile>();
    @NotNull
    private final SyncListener mySyncListener = new SyncListener();
    @NotNull
    private final FileEditorManagerListener myFileEditorListener;

    @NotNull
    public static GradleFiles getInstance(@NotNull Project project) {
        return (GradleFiles)ServiceManager.getService((Project)project, GradleFiles.class);
    }

    private GradleFiles(@NotNull Project project) {
        this.myProject = project;
        final GradleFileChangeListener fileChangeListener = new GradleFileChangeListener(this);
        this.myFileEditorListener = new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event.getNewFile() == null || !event.getNewFile().isValid()) {
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)GradleFiles.this.myProject).findFile(event.getNewFile());
                if (psiFile == null) {
                    return;
                }
                if (GradleFiles.this.isGradleFile(psiFile) || GradleFiles.this.isExternalBuildFile(psiFile)) {
                    PsiManager.getInstance((Project)GradleFiles.this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)fileChangeListener);
                } else {
                    PsiManager.getInstance((Project)GradleFiles.this.myProject).removePsiTreeChangeListener((PsiTreeChangeListener)fileChangeListener);
                }
            }
        };
        if (this.myProject.isDefault()) {
            return;
        }
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this.myFileEditorListener);
        GradleSyncState.subscribe(this.myProject, this.mySyncListener);
        if (this.myProject.isInitialized()) {
            this.scheduleUpdateFileHashes();
        } else {
            StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(this::scheduleUpdateFileHashes);
        }
    }

    @NotNull
    GradleSyncListener getSyncListener() {
        return this.mySyncListener;
    }

    @NotNull
    FileEditorManagerListener getFileEditorListener() {
        return this.myFileEditorListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasHashForFile(@NotNull VirtualFile file) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myFileHashes.containsKey(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChangedFiles() {
        Object object = this.myLock;
        synchronized (object) {
            this.myChangedFiles.clear();
            this.myChangedExternalFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChangedFile(@NotNull VirtualFile file, boolean isExternal) {
        Object object = this.myLock;
        synchronized (object) {
            if (isExternal) {
                this.myChangedExternalFiles.add(file);
            } else {
                this.myChangedFiles.add(file);
            }
        }
    }

    private void putHashForFile(@NotNull Map<VirtualFile, Integer> map2, @NotNull VirtualFile file) {
        Integer hash2 = this.computeHash(file);
        if (hash2 != null) {
            map2.put(file, hash2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeHashesForFiles(@NotNull Map<VirtualFile, Integer> files2) {
        Object object = this.myLock;
        synchronized (object) {
            this.myFileHashes.clear();
            this.myFileHashes.putAll(files2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Integer getStoredHashForFile(@NotNull VirtualFile file) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myFileHashes.get(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsChangedFile(@NotNull VirtualFile file) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myChangedFiles.contains(file) || this.myChangedExternalFiles.contains(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExternalBuildFiles() {
        Object object = this.myLock;
        synchronized (object) {
            this.myExternalBuildFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeExternalBuildFiles(@NotNull Collection<VirtualFile> externalBuildFiles) {
        Object object = this.myLock;
        synchronized (object) {
            this.myExternalBuildFiles.addAll(externalBuildFiles);
        }
    }

    @Nullable
    private Integer computeHash(@NotNull VirtualFile file) {
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile != null && psiFile.isValid()) {
            return psiFile.getText().hashCode();
        }
        return null;
    }

    private boolean areHashesEqual(@NotNull VirtualFile file) {
        Integer oldHash = this.getStoredHashForFile(file);
        return oldHash != null && oldHash.equals(this.computeHash(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkHashesOfChangedFiles() {
        Object object = this.myLock;
        synchronized (object) {
            return this.filterHashes(this.myChangedFiles) && this.filterHashes(this.myChangedExternalFiles);
        }
    }

    private boolean filterHashes(@NotNull Collection<VirtualFile> files2) {
        boolean status = true;
        HashSet<VirtualFile> toRemove = new HashSet<VirtualFile>();
        for (VirtualFile file : files2) {
            if (!this.areHashesEqual(file)) {
                status = false;
                continue;
            }
            toRemove.add(file);
        }
        files2.removeAll(toRemove);
        return status;
    }

    private void scheduleUpdateFileHashes() {
        TransactionGuard.getInstance().submitTransactionLater((Disposable)this.myProject, () -> {
            VirtualFile propertiesFile;
            File propertiesFilePath;
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            HashMap<VirtualFile, Integer> fileHashes = new HashMap<VirtualFile, Integer>();
            GradleWrapper gradleWrapper = GradleWrapper.find(this.myProject);
            if (gradleWrapper != null && (propertiesFilePath = gradleWrapper.getPropertiesFilePath()).isFile() && (propertiesFile = gradleWrapper.getPropertiesFile()) != null) {
                this.putHashForFile(fileHashes, propertiesFile);
            }
            this.removeExternalBuildFiles();
            ArrayList<VirtualFile> externalBuildFiles = new ArrayList<VirtualFile>();
            ArrayList modules = Lists.newArrayList((Object[])ModuleManager.getInstance((Project)this.myProject).getModules());
            JobLauncher jobLauncher = JobLauncher.getInstance();
            jobLauncher.invokeConcurrentlyUnderProgress((List)modules, null, module -> {
                NdkModuleModel ndkModuleModel;
                File path;
                VirtualFile buildFile = GradleUtil.getGradleBuildFile(module);
                if (buildFile != null && (path = VfsUtilCore.virtualToIoFile((VirtualFile)buildFile)).isFile()) {
                    this.putHashForFile(fileHashes, buildFile);
                }
                if ((ndkModuleModel = NdkModuleModel.get(module)) != null) {
                    for (File externalBuildFile : ndkModuleModel.getAndroidProject().getBuildFiles()) {
                        if (!externalBuildFile.isFile()) continue;
                        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)externalBuildFile, (boolean)true);
                        externalBuildFiles.add(virtualFile);
                        if (virtualFile == null) continue;
                        this.putHashForFile(fileHashes, virtualFile);
                    }
                }
                return true;
            });
            this.storeExternalBuildFiles(externalBuildFiles);
            String[] fileNames = new String[]{"settings.gradle", "settings.gradle.kts", "gradle.properties"};
            File rootFolderPath = Projects.getBaseDirPath((Project)this.myProject);
            VirtualFile rootFolder = ProjectUtil.guessProjectDir((Project)this.myProject);
            if (rootFolder != null) {
                for (String fileName : fileNames) {
                    VirtualFile virtualFile;
                    File filePath = new File(rootFolderPath, fileName);
                    if (!filePath.isFile() || (virtualFile = rootFolder.findChild(fileName)) == null || !virtualFile.exists() || virtualFile.isDirectory()) continue;
                    this.putHashForFile(fileHashes, virtualFile);
                }
            }
            this.storeHashesForFiles(fileHashes);
        });
    }

    public boolean areGradleFilesModified() {
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> !this.checkHashesOfChangedFiles());
    }

    public boolean areExternalBuildFilesModified() {
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myLock;
            synchronized (object) {
                return !this.filterHashes(this.myChangedExternalFiles);
            }
        });
    }

    public boolean isGradleFile(@NotNull PsiFile psiFile) {
        VirtualFile file;
        if (psiFile.getFileType() == GroovyFileType.GROOVY_FILE_TYPE && (file = psiFile.getVirtualFile()) != null && "gradle".equals(file.getExtension())) {
            return true;
        }
        if (psiFile.getFileType() == PropertiesFileType.INSTANCE && (file = psiFile.getVirtualFile()) != null && ("gradle.properties".equals(file.getName()) || "gradle-wrapper.properties".equals(file.getName()))) {
            return true;
        }
        return psiFile.getFileType().getName().equals("Kotlin") && ((file = psiFile.getVirtualFile()) != null && "build.gradle.kts".equals(file.getName()) || "settings.gradle.kts".equals(file.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExternalBuildFile(@NotNull PsiFile psiFile) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myExternalBuildFiles.contains(psiFile.getVirtualFile());
        }
    }

    private static class GradleFileChangeListener
    extends PsiTreeChangeAdapter {
        @NotNull
        private final GradleFiles myGradleFiles;

        private GradleFileChangeListener(@NotNull GradleFiles gradleFiles) {
            this.myGradleFiles = gradleFiles;
        }

        public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
            this.processEvent(event, event.getChild());
        }

        public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
            this.processEvent(event, event.getChild());
        }

        public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
            this.processEvent(event, event.getNewChild(), event.getOldChild());
        }

        public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
            this.processEvent(event, event.getChild());
        }

        public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
            this.processEvent(event, event.getOldChild(), event.getNewChild());
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            this.processEvent(event, event.getChild());
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            this.processEvent(event, event.getChild());
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            this.processEvent(event, event.getNewChild(), event.getOldChild());
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            this.processEvent(event, event.getChild());
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            this.processEvent(event, event.getOldChild(), event.getNewChild());
        }

        private void processEvent(@NotNull PsiTreeChangeEvent event, PsiElement ... elements) {
            PsiFile psiFile = event.getFile();
            if (psiFile == null) {
                return;
            }
            boolean isExternalBuildFile = this.myGradleFiles.isExternalBuildFile(psiFile);
            if (!this.myGradleFiles.isGradleFile(psiFile) && !isExternalBuildFile) {
                return;
            }
            if (this.myGradleFiles.containsChangedFile(psiFile.getVirtualFile())) {
                return;
            }
            if (!this.myGradleFiles.myProject.isInitialized() || !PsiManager.getInstance((Project)this.myGradleFiles.myProject).isInProject((PsiElement)psiFile)) {
                return;
            }
            boolean foundChange = false;
            for (PsiElement element : elements) {
                if (element == null || element instanceof PsiWhiteSpace || element.getNode().getElementType().equals(GroovyTokenTypes.mNLS) && (element.getParent() == null || element.getParent() instanceof GrCodeBlock || element.getParent() instanceof PsiFile)) continue;
                foundChange = true;
                break;
            }
            if (foundChange) {
                this.myGradleFiles.addChangedFile(psiFile.getVirtualFile(), isExternalBuildFile);
                EditorNotifications.getInstance((Project)psiFile.getProject()).updateNotifications(psiFile.getVirtualFile());
            }
        }
    }

    private class SyncListener
    implements GradleSyncListener {
        private SyncListener() {
        }

        @Override
        public void syncStarted(@NotNull Project project, boolean skipped, boolean sourceGenerationRequested) {
            this.maybeProcessSyncStarted(project);
        }

        private void maybeProcessSyncStarted(@NotNull Project project) {
            if (!project.isInitialized() && project.equals(GradleFiles.this.myProject)) {
                return;
            }
            GradleFiles.this.scheduleUpdateFileHashes();
            GradleFiles.this.removeChangedFiles();
        }
    }
}

