/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.project.build.output.AndroidGradleSyncTextConsoleView;
import com.android.tools.idea.gradle.project.importing.OpenMigrationToGradleUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.GradleSync;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.cleanup.PreSyncProjectCleanUp;
import com.android.tools.idea.gradle.project.sync.idea.IdeaGradleSync;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.ng.NewGradleSync;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlySyncOptions;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncCheckResult;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncChecks;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.base.Strings;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSyncInvoker {
    @NotNull
    private final FileDocumentManager myFileDocumentManager;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final PreSyncProjectCleanUp myPreSyncProjectCleanUp;
    @NotNull
    private final PreSyncChecks myPreSyncChecks;

    @NotNull
    public static GradleSyncInvoker getInstance() {
        return (GradleSyncInvoker)ServiceManager.getService(GradleSyncInvoker.class);
    }

    public GradleSyncInvoker(@NotNull FileDocumentManager fileDocumentManager, @NotNull IdeInfo ideInfo) {
        this(fileDocumentManager, ideInfo, new PreSyncProjectCleanUp(), new PreSyncChecks());
    }

    private GradleSyncInvoker(@NotNull FileDocumentManager fileDocumentManager, @NotNull IdeInfo ideInfo, @NotNull PreSyncProjectCleanUp preSyncProjectCleanUp, @NotNull PreSyncChecks preSyncChecks) {
        this.myFileDocumentManager = fileDocumentManager;
        this.myIdeInfo = ideInfo;
        this.myPreSyncProjectCleanUp = preSyncProjectCleanUp;
        this.myPreSyncChecks = preSyncChecks;
    }

    public void requestProjectSyncAndSourceGeneration(@NotNull Project project, @NotNull GradleSyncStats.Trigger trigger) {
        this.requestProjectSyncAndSourceGeneration(project, trigger, null);
    }

    public void requestProjectSyncAndSourceGeneration(@NotNull Project project, @NotNull GradleSyncStats.Trigger trigger, @Nullable GradleSyncListener listener2) {
        Request request = new Request(trigger);
        this.requestProjectSync(project, request, listener2);
    }

    public void requestProjectSync(@NotNull Project project, @NotNull Request request) {
        this.requestProjectSync(project, request, null);
    }

    public void requestProjectSync(@NotNull Project project, @NotNull Request request, @Nullable GradleSyncListener listener2) {
        if (GradleSyncState.getInstance(project).isSyncInProgress()) {
            return;
        }
        if (GradleSyncInvoker.isBuildInProgress(project)) {
            GradleProjects.setSyncRequestedDuringBuild(project, true);
            return;
        }
        Runnable syncTask = () -> {
            ExternalSystemUtil.ensureToolWindowContentInitialized((Project)project, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID);
            if (this.prepareProject(project, listener2)) {
                this.sync(project, request, listener2);
            }
        };
        GradleSyncState.getInstance(project).syncTaskCreated(request);
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            application.invokeAndWait(syncTask);
            return;
        }
        if (request.runInBackground) {
            TransactionGuard.getInstance().submitTransactionLater((Disposable)project, syncTask);
        } else {
            TransactionGuard.getInstance().submitTransactionAndWait(syncTask);
        }
    }

    private static boolean isBuildInProgress(@NotNull Project project) {
        StatusBarEx statusBar;
        IdeFrame frame = ((WindowManagerEx)WindowManager.getInstance()).findFrameFor(project);
        StatusBarEx statusBarEx = statusBar = frame == null ? null : (StatusBarEx)frame.getStatusBar();
        if (statusBar == null) {
            return false;
        }
        for (Pair backgroundProcess : statusBar.getBackgroundProcesses()) {
            ProgressIndicator second;
            TaskInfo task = (TaskInfo)backgroundProcess.getFirst();
            if (!(task instanceof GradleTasksExecutor) || !(second = (ProgressIndicator)backgroundProcess.getSecond()).isRunning()) continue;
            return true;
        }
        return false;
    }

    private boolean prepareProject(@NotNull Project project, @Nullable GradleSyncListener listener2) {
        GradleProjectInfo projectInfo = GradleProjectInfo.getInstance(project);
        if (AndroidProjectInfo.getInstance(project).requiresAndroidModel() || projectInfo.hasTopLevelGradleBuildFile()) {
            boolean isImportedProject = projectInfo.isImportedProject();
            if (!isImportedProject) {
                this.myFileDocumentManager.saveAllDocuments();
            }
            return true;
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> {
            String msg = String.format("The project '%s' is not a Gradle-based project", project.getName());
            AndroidNotification.getInstance(project).showBalloon("Project Sync", msg, NotificationType.ERROR, new OpenMigrationToGradleUrlHyperlink());
            if (listener2 != null) {
                listener2.syncFailed(project, msg);
            }
        });
        return false;
    }

    private void sync(@NotNull Project project, @NotNull Request request, @Nullable GradleSyncListener listener2) {
        boolean useNewGradleSync;
        PreSyncCheckResult checkResult;
        if (this.myIdeInfo.isAndroidStudio()) {
            GradleUtil.clearStoredGradleJvmArgs(project);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> GradleSyncMessages.getInstance(project).removeProjectMessages());
        if (!request.skipPreSyncChecks && !(checkResult = this.runPreSyncChecks(project)).isSuccess()) {
            String cause = Strings.nullToEmpty((String)checkResult.getFailureCause());
            GradleSyncInvoker.handlePreSyncCheckFailure(project, cause, listener2, request);
            return;
        }
        this.myPreSyncProjectCleanUp.cleanUp(project);
        boolean isImportedProject = GradleProjectInfo.getInstance(project).isImportedProject();
        boolean started = request.useCachedGradleModels ? GradleSyncState.getInstance(project).skippedSyncStarted(!isImportedProject, request) : GradleSyncState.getInstance(project).syncStarted(!isImportedProject, request);
        if (!started) {
            return;
        }
        if (listener2 != null) {
            listener2.syncStarted(project, request.useCachedGradleModels, request.generateSourcesOnSuccess);
        }
        GradleSync gradleSync = (useNewGradleSync = NewGradleSync.isEnabled(project)) ? new NewGradleSync(project) : new IdeaGradleSync(project);
        gradleSync.sync(request, listener2);
    }

    @NotNull
    PreSyncCheckResult runPreSyncChecks(@NotNull Project project) {
        return this.myPreSyncChecks.canSyncAndTryToFix(project);
    }

    private static void handlePreSyncCheckFailure(@NotNull Project project, @NotNull String failureCause, @Nullable GradleSyncListener syncListener, @NotNull Request request) {
        GradleSyncState syncState = GradleSyncState.getInstance(project);
        ExternalSystemTaskId taskId = GradleSyncInvoker.createFailedPreCheckSyncTaskWithStartMessage(project);
        syncState.setExternalSystemTaskId(taskId);
        if (syncState.syncStarted(true, request)) {
            if (syncListener != null) {
                syncListener.syncStarted(project, request.useCachedGradleModels, request.generateSourcesOnSuccess);
            }
            syncState.syncFailed(failureCause);
            if (syncListener != null) {
                syncListener.syncFailed(project, failureCause);
            }
        }
        GradleSyncMessages messages = GradleSyncMessages.getInstance(project);
        List<Failure> failures = messages.showEvents(taskId);
        FailureResultImpl result2 = new FailureResultImpl(failures);
        FinishBuildEventImpl finishBuildEvent = new FinishBuildEventImpl((Object)taskId, null, System.currentTimeMillis(), failureCause, (EventResult)result2);
        ((SyncViewManager)ServiceManager.getService((Project)project, SyncViewManager.class)).onEvent((BuildEvent)finishBuildEvent);
    }

    @NotNull
    public static ExternalSystemTaskId createFailedPreCheckSyncTaskWithStartMessage(@NotNull Project project) {
        ExternalSystemTaskId taskId = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)project);
        String workingDir = FileUtil.toCanonicalPath((String)Projects.getBaseDirPath((Project)project).getPath());
        DefaultBuildDescriptor buildDescriptor = new DefaultBuildDescriptor((Object)taskId, "Preparing for sync", workingDir, System.currentTimeMillis());
        SyncViewManager syncManager = (SyncViewManager)ServiceManager.getService((Project)project, SyncViewManager.class);
        syncManager.onEvent((BuildEvent)new StartBuildEventImpl((BuildDescriptor)buildDescriptor, "Running pre sync checks...").withContentDescriptorSupplier(() -> {
            AndroidGradleSyncTextConsoleView consoleView = new AndroidGradleSyncTextConsoleView(project);
            return new RunContentDescriptor((ExecutionConsole)consoleView, null, consoleView.getComponent(), "Gradle Sync");
        }));
        return taskId;
    }

    @NotNull
    public List<GradleModuleModels> fetchGradleModels(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        GradleSync gradleSync = NewGradleSync.isEnabled(project) ? new NewGradleSync(project) : new IdeaGradleSync(project);
        return gradleSync.fetchGradleModels(indicator);
    }

    public static class Request {
        public final GradleSyncStats.Trigger trigger;
        public boolean runInBackground = true;
        public boolean generateSourcesOnSuccess = true;
        public boolean cleanProject;
        public boolean useCachedGradleModels;
        public boolean skipAndroidPluginUpgrade;
        public boolean forceFullVariantsSync;
        public boolean skipPreSyncChecks;
        @Nullable
        public VariantOnlySyncOptions variantOnlySyncOptions;

        @NotNull
        public static Request testRequest() {
            return new Request(GradleSyncStats.Trigger.TRIGGER_TEST_REQUESTED);
        }

        public Request(@NotNull GradleSyncStats.Trigger trigger) {
            this.trigger = trigger;
        }

        @NotNull
        public ProgressExecutionMode getProgressExecutionMode() {
            return this.runInBackground ? ProgressExecutionMode.IN_BACKGROUND_ASYNC : ProgressExecutionMode.MODAL_SYNC;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.trigger == request.trigger && this.runInBackground == request.runInBackground && this.generateSourcesOnSuccess == request.generateSourcesOnSuccess && this.cleanProject == request.cleanProject && this.useCachedGradleModels == request.useCachedGradleModels && this.skipAndroidPluginUpgrade == request.skipAndroidPluginUpgrade && this.forceFullVariantsSync == request.forceFullVariantsSync && this.skipPreSyncChecks == request.skipPreSyncChecks && Objects.equals(this.variantOnlySyncOptions, request.variantOnlySyncOptions);
        }

        public int hashCode() {
            return Objects.hash(this.trigger, this.runInBackground, this.generateSourcesOnSuccess, this.cleanProject, this.useCachedGradleModels, this.skipAndroidPluginUpgrade, this.forceFullVariantsSync, this.skipPreSyncChecks, this.variantOnlySyncOptions);
        }

        public String toString() {
            return "RequestSettings{trigger=" + this.trigger + ", runInBackground=" + this.runInBackground + ", generateSourcesOnSuccess=" + this.generateSourcesOnSuccess + ", cleanProject=" + this.cleanProject + ", useCachedGradleModels=" + this.useCachedGradleModels + ", skipAndroidPluginUpgrade=" + this.skipAndroidPluginUpgrade + ", forceFullVariantsSync=" + this.forceFullVariantsSync + ", skipPreSyncChecks=" + this.skipPreSyncChecks + ", variantOnlySyncOptions=" + this.variantOnlySyncOptions + '}';
        }
    }
}

