/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.builder.model.level2.Library;
import com.android.ide.common.gradle.model.level2.IdeDependencies;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.settings.AndroidStudioGradleIdeSettings;
import com.android.tools.idea.gradle.project.sync.GradleFiles;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncSummary;
import com.android.tools.idea.gradle.project.sync.hyperlink.DoNotShowJdkHomeWarningAgainHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.UseJavaHomeAsJdkHyperlink;
import com.android.tools.idea.gradle.project.sync.ng.NewGradleSync;
import com.android.tools.idea.gradle.project.sync.projectsystem.GradleSyncResultPublisher;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.project.IndexingSuspender;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.lint.detector.api.Lint;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Ordering;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.google.wireless.android.sdk.stats.KotlinSupport;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import net.jcip.annotations.GuardedBy;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSyncState {
    private static final Logger LOG = Logger.getInstance(GradleSyncState.class);
    private static final NotificationGroup SYNC_NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup((String)"Gradle sync");
    public static final NotificationGroup JDK_LOCATION_WARNING_NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup((String)"JDK Location different to JAVA_HOME");
    @VisibleForTesting
    static final Topic<GradleSyncListener> GRADLE_SYNC_TOPIC = new Topic("Project sync with Gradle", GradleSyncListener.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final AndroidProjectInfo myAndroidProjectInfo;
    @NotNull
    private final GradleProjectInfo myGradleProjectInfo;
    @NotNull
    private final MessageBus myMessageBus;
    @NotNull
    private final StateChangeNotification myChangeNotification;
    @NotNull
    private final GradleSyncSummary mySummary;
    @NotNull
    private final ProjectStructure myProjectStructure;
    @NotNull
    private final Object myLock = new Object();
    @GuardedBy(value="myLock")
    private boolean mySyncNotificationsEnabled;
    @GuardedBy(value="myLock")
    private boolean mySyncSkipped;
    @GuardedBy(value="myLock")
    private boolean mySyncInProgress;
    private long mySyncStartedTimestamp = -1L;
    private long mySyncSetupStartedTimeStamp = -1L;
    private long mySyncEndedTimeStamp = -1L;
    private long mySourceGenerationEndedTimeStamp = -1L;
    private long mySyncFailedTimeStamp = -1L;
    private GradleSyncStats.Trigger myTrigger = GradleSyncStats.Trigger.TRIGGER_UNKNOWN;
    private boolean myShouldRemoveModelsOnFailure = false;
    @GuardedBy(value="myLock")
    @Nullable
    private ExternalSystemTaskId myExternalSystemTaskId;

    @NotNull
    public static MessageBusConnection subscribe(@NotNull Project project, @NotNull GradleSyncListener listener2) {
        return GradleSyncState.subscribe(project, listener2, (Disposable)project);
    }

    @NotNull
    public static MessageBusConnection subscribe(@NotNull Project project, @NotNull GradleSyncListener listener2, @NotNull Disposable parentDisposable) {
        MessageBusConnection connection = project.getMessageBus().connect(parentDisposable);
        connection.subscribe(GRADLE_SYNC_TOPIC, (Object)listener2);
        return connection;
    }

    @NotNull
    public static GradleSyncState getInstance(@NotNull Project project) {
        return (GradleSyncState)ServiceManager.getService((Project)project, GradleSyncState.class);
    }

    public GradleSyncState(@NotNull Project project, @NotNull AndroidProjectInfo androidProjectInfo, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull MessageBus messageBus, @NotNull ProjectStructure projectStructure) {
        this(project, androidProjectInfo, gradleProjectInfo, messageBus, projectStructure, new StateChangeNotification(project), new GradleSyncSummary(project));
    }

    @VisibleForTesting
    GradleSyncState(@NotNull Project project, @NotNull AndroidProjectInfo androidProjectInfo, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull MessageBus messageBus, @NotNull ProjectStructure projectStructure, @NotNull StateChangeNotification changeNotification, @NotNull GradleSyncSummary summary) {
        this.myProject = project;
        this.myAndroidProjectInfo = androidProjectInfo;
        this.myGradleProjectInfo = gradleProjectInfo;
        this.myMessageBus = messageBus;
        this.myChangeNotification = changeNotification;
        this.mySummary = summary;
        this.myProjectStructure = projectStructure;
        IndexingSuspender.ensureInitialised(this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areSyncNotificationsEnabled() {
        Object object = this.myLock;
        synchronized (object) {
            return this.mySyncNotificationsEnabled;
        }
    }

    public boolean skippedSyncStarted(boolean notifyUser, @NotNull GradleSyncInvoker.Request request) {
        return this.syncStarted(true, notifyUser, request);
    }

    public void syncTaskCreated(@NotNull GradleSyncInvoker.Request request) {
        this.syncPublisher(() -> ((GradleSyncListener)this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncTaskCreated(this.myProject, request));
    }

    public boolean syncStarted(boolean notifyUser, @NotNull GradleSyncInvoker.Request request) {
        return this.syncStarted(false, notifyUser, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncStarted(boolean syncSkipped, boolean notifyUser, @NotNull GradleSyncInvoker.Request request) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.mySyncInProgress) {
                LOG.info(String.format("Sync already in progress for project '%1$s'.", this.myProject.getName()));
                return false;
            }
            this.mySyncSkipped = syncSkipped;
            this.mySyncInProgress = true;
        }
        this.myShouldRemoveModelsOnFailure = request.variantOnlySyncOptions == null;
        String syncType = NewGradleSync.isSingleVariantSync(this.myProject) ? "single-variant" : "IDEA";
        LOG.info(String.format("Started %1$s sync with Gradle for project '%2$s'.", syncType, this.myProject.getName()));
        this.setSyncStartedTimeStamp(System.currentTimeMillis(), request.trigger);
        this.addInfoToSyncEventLog(String.format("Gradle sync started with %1$s sync", syncType));
        if (notifyUser) {
            this.notifyStateChanged();
        }
        if (this.mySummary.getSyncTimestamp() < 0L) {
            GradleSyncResultPublisher.getInstance(this.myProject);
        }
        this.mySummary.reset();
        this.syncPublisher(() -> ((GradleSyncListener)this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncStarted(this.myProject, syncSkipped, request.generateSourcesOnSuccess));
        this.logSyncEvent(AndroidStudioEvent.EventKind.GRADLE_SYNC_STARTED);
        return true;
    }

    @VisibleForTesting
    void setSyncStartedTimeStamp(long timeStampMs, GradleSyncStats.Trigger trigger) {
        this.mySyncStartedTimestamp = timeStampMs;
        this.mySyncSetupStartedTimeStamp = -1L;
        this.mySyncEndedTimeStamp = -1L;
        this.mySourceGenerationEndedTimeStamp = -1L;
        this.mySyncFailedTimeStamp = -1L;
        this.myTrigger = trigger;
    }

    @VisibleForTesting
    void setSyncSetupStartedTimeStamp(long timeStampMs) {
        this.mySyncSetupStartedTimeStamp = timeStampMs;
    }

    @VisibleForTesting
    void setSyncEndedTimeStamp(long timeStampMs) {
        this.mySyncEndedTimeStamp = timeStampMs;
    }

    @VisibleForTesting
    void setSourceGenerationEndedTimeStamp(long timeStampMs) {
        this.mySourceGenerationEndedTimeStamp = timeStampMs;
    }

    @VisibleForTesting
    public boolean isSourceGenerationFinished() {
        return this.mySourceGenerationEndedTimeStamp != -1L;
    }

    @VisibleForTesting
    void setSyncFailedTimeStamp(long timeStampMs) {
        this.mySyncFailedTimeStamp = timeStampMs;
    }

    public void syncSkipped(long lastSyncTimestamp) {
        long syncEndTimestamp = System.currentTimeMillis();
        this.setSyncEndedTimeStamp(syncEndTimestamp);
        String msg = String.format("Gradle sync finished in %1$s (from cached state)", this.getFormattedSyncDuration(syncEndTimestamp));
        this.addInfoToSyncEventLog(msg);
        LOG.info(msg);
        this.stopSyncInProgress();
        this.mySummary.setSyncTimestamp(lastSyncTimestamp);
        this.syncPublisher(() -> ((GradleSyncListener)this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncSkipped(this.myProject));
        this.enableNotifications();
        this.logSyncEvent(AndroidStudioEvent.EventKind.GRADLE_SYNC_SKIPPED);
    }

    public void invalidateLastSync(@NotNull String error) {
        this.syncFailed(error);
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) continue;
            ((AndroidFacetConfiguration)facet.getConfiguration()).setModel(null);
        }
    }

    public void syncFailed(@NotNull String message2) {
        this.myProjectStructure.clearData();
        long syncEndTimestamp = System.currentTimeMillis();
        if (this.mySyncStartedTimestamp == -1L) {
            this.syncFinished(syncEndTimestamp);
            return;
        }
        if (this.myShouldRemoveModelsOnFailure) {
            GradleSyncState.removeAndroidModels(this.myProject);
        }
        this.setSyncFailedTimeStamp(syncEndTimestamp);
        String msg = "Gradle sync failed";
        if (StringUtil.isNotEmpty((String)message2)) {
            msg = msg + String.format(": %1$s", message2);
        }
        msg = msg + String.format(" (%1$s)", this.getFormattedSyncDuration(syncEndTimestamp));
        this.addToSyncEventLog(msg, MessageType.ERROR);
        LOG.info(msg);
        this.logSyncEvent(AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE);
        this.syncFinished(syncEndTimestamp);
        this.syncPublisher(() -> ((GradleSyncListener)this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncFailed(this.myProject, message2));
        this.mySummary.setSyncErrorsFound(true);
    }

    public void syncEnded() {
        assert (!this.lastSyncFailedOrHasIssues());
        long syncEndTimestamp = System.currentTimeMillis();
        if (this.mySyncStartedTimestamp == -1L) {
            this.syncFinished(syncEndTimestamp);
            return;
        }
        this.setSyncEndedTimeStamp(syncEndTimestamp);
        String msg = String.format("Gradle sync finished in %1$s", this.getFormattedSyncDuration(syncEndTimestamp));
        this.addInfoToSyncEventLog(msg);
        LOG.info(msg);
        Lint.setTryPrefixLookup((boolean)true);
        this.logSyncEvent(AndroidStudioEvent.EventKind.GRADLE_SYNC_ENDED);
        this.syncFinished(syncEndTimestamp);
        this.syncPublisher(() -> ((GradleSyncListener)this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).syncSucceeded(this.myProject));
    }

    private long getSyncDurationMS(long syncEndTimestamp) {
        return syncEndTimestamp - this.mySyncStartedTimestamp;
    }

    @VisibleForTesting
    @NotNull
    String getFormattedSyncDuration(long syncEndTimestamp) {
        return StringUtil.formatDuration((long)this.getSyncDurationMS(syncEndTimestamp));
    }

    private void addInfoToSyncEventLog(@NotNull String message2) {
        this.addToSyncEventLog(message2, MessageType.INFO);
    }

    private void addToSyncEventLog(@NotNull String message2, @NotNull MessageType type) {
        this.addToEventLog(SYNC_NOTIFICATION_GROUP, message2, type, null);
    }

    private void addWarningToJdkEventLog(@NotNull String message2, @Nullable List<NotificationHyperlink> quickFixes) {
        this.addToEventLog(JDK_LOCATION_WARNING_NOTIFICATION_GROUP, message2, MessageType.WARNING, quickFixes);
    }

    private void addToEventLog(@NotNull NotificationGroup notificationGroup, @NotNull String message2, @NotNull MessageType type, final @Nullable List<NotificationHyperlink> quickFixes) {
        StringBuilder msg = new StringBuilder(message2);
        NotificationListener listener2 = null;
        if (quickFixes != null) {
            for (NotificationHyperlink quickFix : quickFixes) {
                msg.append("\n").append(quickFix.toHtml());
            }
            listener2 = new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    for (NotificationHyperlink quickFix : quickFixes) {
                        quickFix.executeIfClicked(GradleSyncState.this.myProject, event);
                    }
                }
            };
        }
        notificationGroup.createNotification("", msg.toString(), type.toNotificationType(), listener2).notify(this.myProject);
    }

    private void syncFinished(long timestamp) {
        this.stopSyncInProgress();
        this.mySyncStartedTimestamp = -1L;
        this.mySummary.setSyncTimestamp(timestamp);
        this.enableNotifications();
        this.notifyStateChanged();
        ApplicationManager.getApplication().invokeAndWait(() -> this.warnIfNotJdkHome());
    }

    private void warnIfNotJdkHome() {
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            return;
        }
        if (!NotificationsConfigurationImpl.getSettings((String)JDK_LOCATION_WARNING_NOTIFICATION_GROUP.getDisplayId()).isShouldLog()) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        IdeSdks ideSdks = IdeSdks.getInstance();
        if (ideSdks.isUsingJavaHomeJdk()) {
            return;
        }
        String javaHome = IdeSdks.getJdkFromJavaHome();
        if (javaHome == null) {
            return;
        }
        if (ideSdks.validateJdkPath(new File(javaHome)) == null) {
            return;
        }
        ArrayList<NotificationHyperlink> quickFixes = new ArrayList<NotificationHyperlink>();
        quickFixes.add(new OpenUrlHyperlink("https://docs.gradle.org/current/userguide/gradle_daemon.html#sec:why_is_there_more_than_one_daemon_process_on_my_machine", "More info..."));
        UseJavaHomeAsJdkHyperlink useJavaHomeHyperlink = UseJavaHomeAsJdkHyperlink.create();
        if (useJavaHomeHyperlink != null) {
            quickFixes.add(useJavaHomeHyperlink);
        }
        quickFixes.add(new DoNotShowJdkHomeWarningAgainHyperlink());
        String msg = "Android Studio is using this JDK location:\n" + ideSdks.getJdkPath() + "\nwhich is different to what Gradle uses by default:\n" + javaHome + "\nUsing different locations may spawn multiple Gradle daemons if\nGradle tasks are run from command line while using Android Studio.\n";
        this.addWarningToJdkEventLog(msg, quickFixes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSyncInProgress() {
        Object object = this.myLock;
        synchronized (object) {
            this.mySyncInProgress = false;
            this.mySyncSkipped = false;
            this.myExternalSystemTaskId = null;
        }
    }

    private void syncPublisher(@NotNull Runnable publishingTask) {
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, (Runnable)publishingTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableNotifications() {
        Object object = this.myLock;
        synchronized (object) {
            this.mySyncNotificationsEnabled = true;
        }
    }

    public void notifyStateChanged() {
        this.myChangeNotification.notifyStateChanged();
    }

    public boolean lastSyncFailedOrHasIssues() {
        boolean lastSyncFailed = this.lastSyncFailed();
        boolean hasSyncErrors = this.mySummary.hasSyncErrors();
        return lastSyncFailed || hasSyncErrors;
    }

    public boolean lastSyncFailed() {
        return !this.isSyncInProgress() && this.myGradleProjectInfo.isBuildWithGradle() && (this.myAndroidProjectInfo.requiredAndroidModelMissing() || this.mySummary.hasSyncErrors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSyncInProgress() {
        Object object = this.myLock;
        synchronized (object) {
            return this.mySyncInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSyncSkipped() {
        Object object = this.myLock;
        synchronized (object) {
            return this.mySyncSkipped;
        }
    }

    @NotNull
    public ThreeState isSyncNeeded() {
        return GradleFiles.getInstance(this.myProject).areGradleFilesModified() ? ThreeState.YES : ThreeState.NO;
    }

    public long getLastSyncEndTimeStamp() {
        return this.mySyncEndedTimeStamp;
    }

    @NotNull
    public GradleSyncSummary getSummary() {
        return this.mySummary;
    }

    public void setupStarted() {
        long syncSetupTimestamp = System.currentTimeMillis();
        this.setSyncSetupStartedTimeStamp(syncSetupTimestamp);
        this.addInfoToSyncEventLog("Project setup started");
        LOG.info(String.format("Started setup of project '%1$s'.", this.myProject.getName()));
        this.syncPublisher(() -> ((GradleSyncListener)this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).setupStarted(this.myProject));
        this.logSyncEvent(AndroidStudioEvent.EventKind.GRADLE_SYNC_SETUP_STARTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExternalSystemTaskId(@Nullable ExternalSystemTaskId externalSystemTaskId) {
        Object object = this.myLock;
        synchronized (object) {
            this.myExternalSystemTaskId = externalSystemTaskId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ExternalSystemTaskId getExternalSystemTaskId() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myExternalSystemTaskId;
        }
    }

    public void sourceGenerationFinished() {
        long sourceGenerationEndedTimestamp = System.currentTimeMillis();
        this.setSourceGenerationEndedTimeStamp(sourceGenerationEndedTimestamp);
        this.addInfoToSyncEventLog(String.format("Source generation ended in %1$s", StringUtil.formatDuration((long)(this.mySourceGenerationEndedTimeStamp - this.mySyncSetupStartedTimeStamp))));
        LOG.info(String.format("Finished source generation of project '%1$s'.", this.myProject.getName()));
        this.syncPublisher(() -> ((GradleSyncListener)this.myMessageBus.syncPublisher(GRADLE_SYNC_TOPIC)).sourceGenerationFinished(this.myProject));
    }

    private void logSyncEvent(@NotNull AndroidStudioEvent.EventKind event) {
        if (this.myProject.isDisposed()) {
            return;
        }
        AndroidStudioEvent.Builder eventBuilder = this.generateSyncEvent(event);
        if (event == AndroidStudioEvent.EventKind.GRADLE_SYNC_ENDED) {
            GradleVersion gradleVersion2 = GradleVersions.getInstance().getGradleVersion(this.myProject);
            String gradleVersionString = gradleVersion2 != null ? gradleVersion2.toString() : "";
            eventBuilder.setGradleVersion(gradleVersionString).setKotlinSupport(this.generateKotlinSupportProto());
        }
        UsageTracker.log((AndroidStudioEvent.Builder)eventBuilder);
    }

    @NotNull
    public AndroidStudioEvent.Builder generateSyncEvent(@NotNull AndroidStudioEvent.EventKind kind) {
        AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
        GradleSyncStats.Builder syncStats = GradleSyncStats.newBuilder();
        Set<String> buildFilesTypes = GradleUtil.projectBuildFilesTypes(this.myProject);
        syncStats.setTotalTimeMs(this.getSyncTotalTimeMs()).setIdeTimeMs(this.getSyncIdeTimeMs()).setGradleTimeMs(this.getSyncGradleTimeMs()).setTrigger(this.myTrigger).setEmbeddedRepoEnabled(AndroidStudioGradleIdeSettings.getInstance().isEmbeddedMavenRepoEnabled()).setSyncType(this.getSyncType()).setUsesBuildGradle(buildFilesTypes.contains(".gradle")).setUsesBuildGradleKts(buildFilesTypes.contains(".kts"));
        this.setAndroidGradlePluginVersions(syncStats);
        event.setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(kind).setGradleSyncStats(syncStats);
        return UsageTrackerUtils.withProjectId(event, this.myProject);
    }

    private void setAndroidGradlePluginVersions(GradleSyncStats.Builder stats) {
        String lastSuccessfulVersion;
        String lastKnownVersion = GradleUtil.getLastKnownAndroidGradlePluginVersion(this.myProject);
        if (lastKnownVersion != null) {
            stats.setLastKnownAndroidGradlePluginVersion(lastKnownVersion);
        }
        if ((lastSuccessfulVersion = GradleUtil.getLastSuccessfulAndroidGradlePluginVersion(this.myProject)) != null) {
            stats.setAndroidGradlePluginVersion(lastSuccessfulVersion);
        }
    }

    @NotNull
    private GradleSyncStats.GradleSyncType getSyncType() {
        if (NewGradleSync.isShippedSync(this.myProject)) {
            return GradleSyncStats.GradleSyncType.GRADLE_SYNC_TYPE_SHIPPED;
        }
        if (NewGradleSync.isCompoundSync(this.myProject)) {
            return GradleSyncStats.GradleSyncType.GRADLE_SYNC_TYPE_COMPOUND;
        }
        if (NewGradleSync.isSingleVariantSync(this.myProject)) {
            return GradleSyncStats.GradleSyncType.GRADLE_SYNC_TYPE_SINGLE_VARIANT;
        }
        if (NewGradleSync.isEnabled(this.myProject)) {
            return GradleSyncStats.GradleSyncType.GRADLE_SYNC_TYPE_NEW_SYNC;
        }
        return GradleSyncStats.GradleSyncType.GRADLE_SYNC_TYPE_IDEA;
    }

    @NotNull
    private KotlinSupport.Builder generateKotlinSupportProto() {
        Ordering ordering = Ordering.natural().nullsFirst();
        GradleVersion kotlinVersion = null;
        GradleVersion ktxVersion = null;
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidModuleModel model2 = AndroidModuleModel.get(module);
            if (model2 == null) continue;
            IdeDependencies dependencies = model2.getSelectedMainCompileLevel2Dependencies();
            kotlinVersion = (GradleVersion)ordering.max(kotlinVersion, (Object)GradleSyncState.findVersion("org.jetbrains.kotlin:kotlin-stdlib", dependencies.getJavaLibraries()));
            ktxVersion = (GradleVersion)ordering.max(ktxVersion, (Object)GradleSyncState.findVersion("androidx.core:core-ktx", dependencies.getAndroidLibraries()));
        }
        KotlinSupport.Builder result2 = KotlinSupport.newBuilder();
        if (kotlinVersion != null) {
            result2.setKotlinSupportVersion(kotlinVersion.toString());
        }
        if (ktxVersion != null) {
            result2.setAndroidKtxVersion(ktxVersion.toString());
        }
        return result2;
    }

    @Nullable
    private static GradleVersion findVersion(@NotNull String artifact, @NotNull Iterable<Library> libraries) {
        for (Library library : libraries) {
            String coordinateString = library.getArtifactAddress();
            if (!coordinateString.startsWith(artifact)) continue;
            GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)coordinateString);
            if (coordinate == null) {
                return null;
            }
            return coordinate.getVersion();
        }
        return null;
    }

    @VisibleForTesting
    long getSyncTotalTimeMs() {
        if (this.mySyncEndedTimeStamp >= 0L) {
            return this.mySyncEndedTimeStamp - this.mySyncStartedTimestamp;
        }
        if (this.mySyncFailedTimeStamp >= 0L) {
            return this.mySyncFailedTimeStamp - this.mySyncStartedTimestamp;
        }
        if (this.mySyncSetupStartedTimeStamp >= 0L) {
            return this.mySyncSetupStartedTimeStamp - this.mySyncStartedTimestamp;
        }
        return 0L;
    }

    @VisibleForTesting
    long getSyncIdeTimeMs() {
        if (this.mySyncEndedTimeStamp >= 0L) {
            if (this.mySyncSetupStartedTimeStamp >= 0L) {
                return this.mySyncEndedTimeStamp - this.mySyncSetupStartedTimeStamp;
            }
            return -1L;
        }
        return -1L;
    }

    @VisibleForTesting
    long getSyncGradleTimeMs() {
        if (this.mySyncSetupStartedTimeStamp >= 0L) {
            return this.mySyncSetupStartedTimeStamp - this.mySyncStartedTimestamp;
        }
        return -1L;
    }

    private static void removeAndroidModels(@NotNull Project project) {
        if (project.isDisposed()) {
            return;
        }
        try {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            for (Module module : moduleManager.getModules()) {
                AndroidFacet facet;
                if (module.isDisposed() || (facet = AndroidFacet.getInstance(module)) == null) continue;
                ((AndroidFacetConfiguration)facet.getConfiguration()).setModel(null);
            }
        }
        catch (Throwable t) {
            LOG.error("Failed to remove Android models", t);
        }
    }

    @VisibleForTesting
    static class StateChangeNotification {
        @NotNull
        private final Project myProject;

        StateChangeNotification(@NotNull Project project) {
            this.myProject = project;
        }

        void notifyStateChanged() {
            AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> {
                VirtualFile[] files2;
                EditorNotifications notifications = EditorNotifications.getInstance((Project)this.myProject);
                for (VirtualFile file : files2 = FileEditorManager.getInstance((Project)this.myProject).getOpenFiles()) {
                    try {
                        notifications.updateNotifications(file);
                    }
                    catch (Throwable e) {
                        String filePath = FileUtil.toSystemDependentName((String)file.getPath());
                        String msg = String.format("Failed to update editor notifications for file '%1$s'", filePath);
                        LOG.info(msg, e);
                    }
                }
                BuildVariantView.getInstance(this.myProject).updateContents();
            });
        }
    }
}

