/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.builder.model.NativeAndroidProject;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleFinder;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleSetupContext {
    public static final Key<ModuleFinder> MODULES_BY_GRADLE_PATH_KEY = Key.create((String)"gradle.sync.modules.by.gradle.path");
    @NotNull
    private final Module myModule;
    @NotNull
    private final IdeModifiableModelsProvider myIdeModelsProvider;
    @Nullable
    private final GradleModuleModels myGradleModels;

    @VisibleForTesting
    ModuleSetupContext(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @Nullable GradleModuleModels gradleModels) {
        this.myModule = module;
        this.myIdeModelsProvider = ideModelsProvider;
        this.myGradleModels = gradleModels;
    }

    @Nullable
    public ModuleFinder getModuleFinder() {
        ModuleFinder moduleFinder = (ModuleFinder)this.myModule.getProject().getUserData(MODULES_BY_GRADLE_PATH_KEY);
        if (moduleFinder == null) {
            ModuleFinder temp = new ModuleFinder(this.myModule.getProject());
            for (Module module : this.myIdeModelsProvider.getModules()) {
                GradleFacet gradleFacet = GradleFacet.getInstance(module, this.myIdeModelsProvider);
                if (gradleFacet == null) continue;
                temp.addModule(module, ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH);
            }
            moduleFinder = temp;
            this.store(moduleFinder);
        }
        return moduleFinder;
    }

    private void store(ModuleFinder moduleFinder) {
        this.myModule.getProject().putUserData(MODULES_BY_GRADLE_PATH_KEY, (Object)moduleFinder);
    }

    public boolean hasNativeModel() {
        if (this.myGradleModels != null) {
            return this.myGradleModels.findModel(NativeAndroidProject.class) != null;
        }
        NdkFacet facet = (NdkFacet)((Object)Facets.findFacet(this.myModule, this.myIdeModelsProvider, NdkFacet.getFacetType().getId()));
        return facet != null && facet.getNdkModuleModel() != null;
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public IdeModifiableModelsProvider getIdeModelsProvider() {
        return this.myIdeModelsProvider;
    }

    @NotNull
    public ModifiableRootModel getModifiableRootModel() {
        return this.myIdeModelsProvider.getModifiableRootModel(this.myModule);
    }

    @Nullable
    public GradleModuleModels getGradleModels() {
        return this.myGradleModels;
    }

    public static void removeSyncContextDataFrom(@NotNull Project project) {
        project.putUserData(MODULES_BY_GRADLE_PATH_KEY, null);
    }

    public static class Factory {
        @NotNull
        public ModuleSetupContext create(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider) {
            return new ModuleSetupContext(module, ideModelsProvider, null);
        }

        @NotNull
        public ModuleSetupContext create(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider, @NotNull ModuleFinder moduleFinder, @NotNull GradleModuleModels gradleModels) {
            ModuleSetupContext context = new ModuleSetupContext(module, ideModelsProvider, gradleModels);
            context.store(moduleFinder);
            return context;
        }
    }
}

