/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsdModuleModels
implements GradleModuleModels {
    @NotNull
    private final String myName;
    @NotNull
    private final Map<Class, List<Object>> myModelsByType = new HashMap<Class, List<Object>>();

    public PsdModuleModels(@NotNull String name) {
        this.myName = name;
    }

    public <T> void addModel(@NotNull Class<T> modelType, @NotNull T model2) {
        List objects = this.myModelsByType.computeIfAbsent(modelType, k -> new ArrayList());
        objects.add(model2);
    }

    @Override
    @Nullable
    public <T> T findModel(@NotNull Class<T> modelType) {
        List<Object> models = this.myModelsByType.get(modelType);
        if (models == null || models.isEmpty()) {
            return null;
        }
        assert (models.size() == 1) : "More than one models available, please use findModels() instead.";
        Object model2 = models.get(0);
        assert (modelType.isInstance(model2));
        return modelType.cast(model2);
    }

    @Override
    @Nullable
    public <T> List<T> findModels(@NotNull Class<T> modelType) {
        List<Object> models = this.myModelsByType.get(modelType);
        if (models == null || models.isEmpty()) {
            return null;
        }
        return models.stream().map(model2 -> {
            assert (modelType.isInstance(model2));
            return modelType.cast(model2);
        }).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public String getModuleName() {
        return this.myName;
    }
}

