/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.cleanup;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.sync.cleanup.ProjectCleanUpTask;
import com.android.tools.idea.sdk.IdeSdks;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleJavaProjectOpenProcessor;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

class GradleSettingsCleanUpTask
extends ProjectCleanUpTask {
    GradleSettingsCleanUpTask() {
    }

    @Override
    void cleanUp(@NotNull Project project) {
        if (IdeInfo.getInstance().isAndroidStudio()) {
            Optional existingRootProjectSettings;
            @SystemIndependent String projectBasePath = project.getBasePath();
            if (projectBasePath == null) {
                return;
            }
            String externalProjectPath = ExternalSystemApiUtil.toCanonicalPath((String)projectBasePath);
            GradleSettings gradleSettings = (GradleSettings)ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
            HashSet projectsSettings = new HashSet(gradleSettings.getLinkedProjectsSettings());
            GradleProjectSettings rootProjectCandidate = null;
            if (!projectsSettings.isEmpty() && (existingRootProjectSettings = StreamEx.of((Collection)projectsSettings).findFirst(projectSettings -> FileUtil.pathsEqual((String)externalProjectPath, (String)projectSettings.getExternalProjectPath()))).isPresent()) {
                rootProjectCandidate = (GradleProjectSettings)existingRootProjectSettings.get();
            }
            if (rootProjectCandidate == null) {
                GradleJavaProjectOpenProcessor gradleProjectOpenProcessor = (GradleJavaProjectOpenProcessor)ProjectOpenProcessor.EXTENSION_POINT_NAME.findExtensionOrFail(GradleJavaProjectOpenProcessor.class);
                VirtualFile projectRootFolder = project.getBaseDir();
                projectRootFolder.refresh(false, true);
                if (gradleProjectOpenProcessor.canOpenProject(projectRootFolder)) {
                    rootProjectCandidate = new GradleProjectSettings();
                    rootProjectCandidate.setExternalProjectPath(externalProjectPath);
                    projectsSettings.add(rootProjectCandidate);
                    gradleSettings.setLinkedProjectsSettings((Collection)projectsSettings);
                }
            }
            if (rootProjectCandidate != null) {
                GradleSettingsCleanUpTask.setUpGradleProjectSettings(project, rootProjectCandidate);
            }
        }
    }

    private static void setUpGradleProjectSettings(@NotNull Project project, @NotNull GradleProjectSettings settings) {
        Sdk jdk;
        settings.setUseAutoImport(false);
        if (ApplicationManager.getApplication().isUnitTestMode() && (jdk = IdeSdks.getInstance().getJdk()) != null) {
            settings.setGradleJvm(jdk.getName());
        }
    }
}

