/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.cleanup;

import com.android.tools.idea.gradle.project.sync.cleanup.GradleDistributionCleanUpTask;
import com.android.tools.idea.gradle.project.sync.cleanup.GradleRunnerCleanupTask;
import com.android.tools.idea.gradle.project.sync.cleanup.GradleSettingsCleanUpTask;
import com.android.tools.idea.gradle.project.sync.cleanup.HttpProxySettingsCleanUpTask;
import com.android.tools.idea.gradle.project.sync.cleanup.ProjectCleanUpTask;
import com.android.tools.idea.gradle.project.sync.cleanup.ProjectNotificationsCleanUpTask;
import com.android.tools.idea.gradle.project.sync.cleanup.ProjectPreferencesCleanUpTask;
import com.android.tools.idea.gradle.project.sync.cleanup.SyncIssueCleanupTask;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class PreSyncProjectCleanUp {
    @NotNull
    private final ProjectCleanUpTask[] myCleanUpTasks;

    @NotNull
    public static PreSyncProjectCleanUp getInstance() {
        return (PreSyncProjectCleanUp)ServiceManager.getService(PreSyncProjectCleanUp.class);
    }

    public PreSyncProjectCleanUp() {
        this(new ProjectNotificationsCleanUpTask(), new ProjectPreferencesCleanUpTask(), new GradleRunnerCleanupTask(), new HttpProxySettingsCleanUpTask(), new GradleSettingsCleanUpTask(), new GradleDistributionCleanUpTask(), new SyncIssueCleanupTask());
    }

    @VisibleForTesting
    PreSyncProjectCleanUp(ProjectCleanUpTask ... cleanUpTasks) {
        this.myCleanUpTasks = cleanUpTasks;
    }

    public void cleanUp(@NotNull Project project) {
        for (ProjectCleanUpTask task : this.myCleanUpTasks) {
            task.cleanUp(project);
        }
    }

    @VisibleForTesting
    @NotNull
    ProjectCleanUpTask[] getCleanUpTasks() {
        return this.myCleanUpTasks;
    }
}

