/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.common;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.actions.RefreshLinkedCppProjectsAction;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.common.GradleInitScripts;
import com.android.tools.idea.gradle.project.settings.AndroidStudioGradleIdeSettings;
import com.android.tools.idea.gradle.project.sync.hyperlink.SyncProjectWithExtraCommandLineOptionsHyperlink;
import com.android.tools.idea.gradle.project.sync.ng.NewGradleSync;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.ui.GuiTestingService;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandLineArgs {
    private static Key<String[]> GRADLE_SYNC_COMMAND_LINE_OPTIONS_KEY = Key.create((String)"gradle.sync.command.line.options");
    @NotNull
    private final ApplicationInfo myApplicationInfo;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final GradleInitScripts myInitScripts;
    @NotNull
    private final AndroidStudioGradleIdeSettings myIdeSettings;
    private final boolean myIsNewSync;

    public CommandLineArgs(boolean isNewSync) {
        this(ApplicationInfo.getInstance(), IdeInfo.getInstance(), GradleInitScripts.getInstance(), AndroidStudioGradleIdeSettings.getInstance(), isNewSync);
    }

    @VisibleForTesting
    CommandLineArgs(@NotNull ApplicationInfo applicationInfo, @NotNull IdeInfo ideInfo, @NotNull GradleInitScripts initScripts, @NotNull AndroidStudioGradleIdeSettings ideSettings, boolean isNewSync) {
        this.myApplicationInfo = applicationInfo;
        this.myIdeInfo = ideInfo;
        this.myInitScripts = initScripts;
        this.myIdeSettings = ideSettings;
        this.myIsNewSync = isNewSync;
    }

    @NotNull
    public List<String> get(@Nullable Project project) {
        Boolean refreshExternalNativeModels;
        String[] extraOptions;
        ArrayList<String> args = new ArrayList<String>();
        if (this.myIsNewSync) {
            this.myInitScripts.addApplyJavaLibraryPluginInitScriptCommandLineArg(args);
            this.myInitScripts.addApplyKaptModelBuilderInitScript(args);
            this.myInitScripts.addApplyBuildScriptClasspathModelBuilderInitScript(args);
        }
        args.add("-Djava.awt.headless=true");
        if (project != null && (extraOptions = (String[])project.getUserData(SyncProjectWithExtraCommandLineOptionsHyperlink.EXTRA_GRADLE_COMMAND_LINE_OPTIONS_KEY)) != null) {
            project.putUserData(SyncProjectWithExtraCommandLineOptionsHyperlink.EXTRA_GRADLE_COMMAND_LINE_OPTIONS_KEY, null);
            Collections.addAll(args, extraOptions);
        }
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.only", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.only.advanced", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.invoked.from.ide", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.only.versioned", (int)(NewGradleSync.isLevel4Model() ? 4 : 3)));
        if (this.myIdeInfo.isAndroidStudio() && !CommandLineArgs.isDevBuild(this.myApplicationInfo.getStrictVersion())) {
            args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.studio.version", (String)this.myApplicationInfo.getStrictVersion()));
        }
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.disable.src.download", (boolean)GradleExperimentalSettings.getInstance().SKIP_SRC_AND_JAVADOC_DOWNLOAD_ON_SYNC));
        if (project != null && (refreshExternalNativeModels = (Boolean)project.getUserData(RefreshLinkedCppProjectsAction.REFRESH_EXTERNAL_NATIVE_MODELS_KEY)) != null) {
            project.putUserData(RefreshLinkedCppProjectsAction.REFRESH_EXTERNAL_NATIVE_MODELS_KEY, null);
            args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.refresh.external.native.model", (boolean)refreshExternalNativeModels));
        }
        Application application = ApplicationManager.getApplication();
        boolean isTestingMode = CommandLineArgs.isInTestingMode();
        if (isTestingMode) {
            application.putUserData(GRADLE_SYNC_COMMAND_LINE_OPTIONS_KEY, (Object)ArrayUtil.toStringArray(args));
        }
        if (!((Boolean)StudioFlags.NPW_OFFLINE_REPO_CHECKBOX.get()).booleanValue() && (this.myIdeSettings.isEmbeddedMavenRepoEnabled() || isTestingMode)) {
            this.myInitScripts.addLocalMavenRepoInitScriptCommandLineArg(args);
        }
        return args;
    }

    private static boolean isDevBuild(String version2) {
        return version2.equals("0.0.0.0");
    }

    public static boolean isInTestingMode() {
        GuiTestingService guiTestingService = GuiTestingService.getInstance();
        return guiTestingService != null && guiTestingService.isGuiTestingMode() || ApplicationManager.getApplication().isUnitTestMode();
    }
}

