/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.compatibility;

import com.android.tools.idea.gradle.project.sync.compatibility.VersionCompatibilityChecker;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompatibilityChecksMetadataUpdater {
    private static final String LAST_CHECK_TIMESTAMP_PROPERTY_NAME = "android-component-compatibility-check";
    private final CheckInterval myCheckInterval;

    public CompatibilityChecksMetadataUpdater() {
        String checkIntervalProperty = System.getProperty("android.version.compatibility.check.interval");
        this.myCheckInterval = CheckInterval.find(checkIntervalProperty);
    }

    void initiateUpdateIfNecessary() {
        long lastUpdateCheck;
        if (this.myCheckInterval != CheckInterval.NONE && this.myCheckInterval.needsUpdate(lastUpdateCheck = PropertiesComponent.getInstance().getOrInitLong(LAST_CHECK_TIMESTAMP_PROPERTY_NAME, -1L))) {
            CompatibilityChecksMetadataUpdater.fetchVersionMetadataUpdate(false);
        }
    }

    public void fetchVersionMetadataUpdate() {
        CompatibilityChecksMetadataUpdater.fetchVersionMetadataUpdate(true);
    }

    private static void fetchVersionMetadataUpdate(boolean startedByUser) {
        CompatibilityChecksMetadataUpdater.fetchMetadata().doWhenDone(() -> {
            long now = System.currentTimeMillis();
            PropertiesComponent.getInstance().setValue(LAST_CHECK_TIMESTAMP_PROPERTY_NAME, String.valueOf(now));
        });
    }

    @NotNull
    private static ActionCallback fetchMetadata() {
        ActionCallback callback2 = new ActionCallback();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            String url = "https://dl.google.com/android/studio/metadata/android-component-compatibility.xml";
            try {
                Element metadata = (Element)HttpRequests.request((String)url).connect(request -> {
                    try {
                        return JDOMUtil.load((InputStream)request.getInputStream());
                    }
                    catch (Throwable e) {
                        CompatibilityChecksMetadataUpdater.getLogger().info("Failed to parse XML metadata", e);
                        return null;
                    }
                });
                if (metadata != null) {
                    VersionCompatibilityChecker.getInstance().updateMetadata(metadata);
                    callback2.setDone();
                }
            }
            catch (IOException e) {
                CompatibilityChecksMetadataUpdater.getLogger().info(String.format("Failed to connect to '%1$s'", url), (Throwable)e);
            }
            callback2.setRejected();
        });
        return callback2;
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(CompatibilityChecksMetadataUpdater.class);
    }

    static enum CheckInterval {
        NONE(Long.MAX_VALUE),
        DAILY(TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS)),
        WEEKLY(TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS)),
        TESTING(-1L);

        private final long myIntervalInMs;

        private CheckInterval(long intervalInMs) {
            this.myIntervalInMs = intervalInMs;
        }

        boolean needsUpdate(long lastUpdateTimestampInMs) {
            return System.currentTimeMillis() - lastUpdateTimestampInMs >= this.myIntervalInMs;
        }

        @NotNull
        static CheckInterval find(@Nullable String value2) {
            if (StringUtil.isNotEmpty((String)value2)) {
                for (CheckInterval checkInterval : CheckInterval.values()) {
                    if (!value2.equalsIgnoreCase(checkInterval.name())) continue;
                    return checkInterval;
                }
            }
            return WEEKLY;
        }
    }
}

