/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.compatibility;

import com.android.tools.idea.gradle.project.sync.compatibility.version.VersionRange;
import com.google.common.collect.ImmutableList;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Component {
    @NotNull
    private final String myName;
    @NotNull
    private final VersionRange myVersionRange;
    @NotNull
    private final List<Component> myRequirements;
    @Nullable
    private final String myFailureMessage;

    Component(@NotNull String name, @NotNull String version2, @Nullable String failureMessage) {
        this.myName = name;
        this.myVersionRange = VersionRange.parse(version2);
        this.myFailureMessage = failureMessage;
        this.myRequirements = new ArrayList<Component>();
    }

    @NotNull
    String getName() {
        return this.myName;
    }

    @NotNull
    VersionRange getVersionRange() {
        return this.myVersionRange;
    }

    @Nullable
    String getFailureMessage() {
        return this.myFailureMessage;
    }

    @NotNull
    List<Component> getRequirements() {
        return ImmutableList.copyOf(this.myRequirements);
    }

    void addRequirement(@NotNull Component component) {
        this.myRequirements.add(component);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.myName).append(" ").append(this.myVersionRange);
        if (!this.myRequirements.isEmpty()) {
            String lineSeparator = SystemProperties.getLineSeparator();
            buffer.append(lineSeparator).append("Requirements:");
            for (Component requirement : this.myRequirements) {
                buffer.append(lineSeparator).append("  ").append(requirement);
            }
        }
        return buffer.toString();
    }
}

