/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.compatibility;

import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.compatibility.CompatibilityCheck;
import com.android.tools.idea.gradle.project.sync.compatibility.CompatibilityChecksMetadata;
import com.android.tools.idea.gradle.project.sync.compatibility.CompatibilityChecksMetadataUpdater;
import com.android.tools.idea.gradle.project.sync.compatibility.Component;
import com.android.tools.idea.gradle.project.sync.compatibility.VersionIncompatibility;
import com.android.tools.idea.gradle.project.sync.compatibility.version.ComponentVersionReader;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.project.messages.MessageType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.intellij.lang.annotations.Language;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VersionCompatibilityChecker {
    public static final String VERSION_COMPATIBILITY_ISSUE_GROUP = "Version Compatibility Issues";
    @NotNull
    private CompatibilityChecksMetadata myMetadata = new CompatibilityChecksMetadata(1);

    @NotNull
    public static VersionCompatibilityChecker getInstance() {
        return (VersionCompatibilityChecker)ServiceManager.getService(VersionCompatibilityChecker.class);
    }

    private VersionCompatibilityChecker() {
        new CompatibilityChecksMetadataUpdater().initiateUpdateIfNecessary();
        this.reloadMetadata();
    }

    public void reloadMetadata() {
        this.myMetadata = CompatibilityChecksMetadata.reload();
    }

    @VisibleForTesting
    void reloadMetadataForTesting(@NotNull @Language(value="XML") String metadata) throws JDOMException, IOException {
        this.myMetadata = CompatibilityChecksMetadata.reloadForTesting(metadata);
    }

    boolean updateMetadata(@NotNull Element metadata) {
        try {
            CompatibilityChecksMetadata updated = CompatibilityChecksMetadata.load(metadata);
            if (updated.getDataVersion() > this.myMetadata.getDataVersion()) {
                this.myMetadata = updated;
                File metadataFilePath = CompatibilityChecksMetadata.getSourceFilePath();
                JDOMUtil.write((Element)metadata, (File)metadataFilePath, (String)SystemProperties.getLineSeparator());
                VersionCompatibilityChecker.getLogger().info("Saved component version metadata to: " + metadataFilePath);
                return true;
            }
        }
        catch (Throwable e) {
            VersionCompatibilityChecker.getLogger().info("Failed to update component version metadata", e);
        }
        return false;
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(VersionCompatibilityChecker.class);
    }

    public void checkAndReportComponentIncompatibilities(@NotNull Project project) {
        Module[] modules;
        GradleSyncMessages.getInstance(project).removeMessages(VERSION_COMPATIBILITY_ISSUE_GROUP);
        ComponentVersionAndReaderCache cache2 = new ComponentVersionAndReaderCache();
        HashMap incompatibilitiesByCheck = Maps.newHashMap();
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            this.collectComponentIncompatibilities(module, incompatibilitiesByCheck, cache2);
        }
        if (incompatibilitiesByCheck.isEmpty()) {
            return;
        }
        boolean hasErrors = false;
        for (VersionIncompatibility versionIncompatibility : incompatibilitiesByCheck.values()) {
            if (versionIncompatibility.getType() == MessageType.ERROR) {
                hasErrors = true;
            }
            versionIncompatibility.reportMessages(project);
        }
        if (hasErrors) {
            GradleSyncState.getInstance(project).getSummary().setSyncErrorsFound(true);
        }
    }

    private void collectComponentIncompatibilities(@NotNull Module module, @NotNull Map<String, VersionIncompatibility> incompatibilitiesByCheck, @NotNull ComponentVersionAndReaderCache cache2) {
        for (CompatibilityCheck check : this.myMetadata.getCompatibilityChecks()) {
            Component component = check.getComponent();
            Pair<ComponentVersionReader, String> readerAndVersion = this.getComponentVersion(component, module, cache2);
            if (readerAndVersion == null) continue;
            String version2 = (String)readerAndVersion.getSecond();
            if (!component.getVersionRange().contains(version2)) continue;
            for (Component requirement : component.getRequirements()) {
                String msg;
                Pair<ComponentVersionReader, String> readerAndRequirementVersion = this.getComponentVersion(requirement, module, cache2);
                if (readerAndRequirementVersion == null) continue;
                String requirementVersion = (String)readerAndRequirementVersion.getSecond();
                if (requirement.getVersionRange().contains(requirementVersion)) continue;
                boolean projectLevelCheck = ((ComponentVersionReader)readerAndVersion.getFirst()).isProjectLevel();
                String componentName = check.getComponent().getName();
                String id = projectLevelCheck ? componentName : module.getName() + "." + componentName;
                VersionIncompatibility versionIncompatibility = incompatibilitiesByCheck.get(id);
                if (versionIncompatibility == null) {
                    ComponentVersionReader reader = (ComponentVersionReader)readerAndRequirementVersion.getFirst();
                    versionIncompatibility = new VersionIncompatibility(module, check, readerAndVersion, requirement, reader);
                    incompatibilitiesByCheck.put(id, versionIncompatibility);
                }
                if (((ComponentVersionReader)readerAndRequirementVersion.getFirst()).isProjectLevel()) {
                    if (versionIncompatibility.hasMessages()) continue;
                    msg = String.format("but project is using version %1$s.", requirementVersion);
                    versionIncompatibility.addMessage(msg);
                    continue;
                }
                msg = String.format("Module '%1$s' is using version %2$s", module.getName(), requirementVersion);
                versionIncompatibility.addMessage(msg);
            }
        }
    }

    @Nullable
    private Pair<ComponentVersionReader, String> getComponentVersion(@NotNull Component component, @NotNull Module module, @NotNull ComponentVersionAndReaderCache cache2) {
        Map<String, Pair<ComponentVersionReader, String>> componentVersionsByModule;
        String componentName = component.getName();
        Pair readerAndVersion = cache2.projectComponents.get(componentName);
        if (readerAndVersion == null && (componentVersionsByModule = cache2.moduleComponents.get(componentName)) != null) {
            readerAndVersion = componentVersionsByModule.get(module.getName());
        }
        if (readerAndVersion != null) {
            return readerAndVersion;
        }
        ComponentVersionReader reader = this.myMetadata.findComponentVersionReader(componentName);
        if (reader == null) {
            VersionCompatibilityChecker.getLogger().info(String.format("Failed to find version reader for component '%1$s'", componentName));
            return null;
        }
        if (!reader.appliesTo(module)) {
            return null;
        }
        String version2 = reader.getComponentVersion(module);
        if (version2 != null) {
            readerAndVersion = Pair.create((Object)reader, (Object)version2);
            if (reader.isProjectLevel()) {
                cache2.projectComponents.put(componentName, (Pair<ComponentVersionReader, String>)readerAndVersion);
            } else {
                Map componentVersionsByModule2 = cache2.moduleComponents.computeIfAbsent(componentName, k -> Maps.newHashMap());
                componentVersionsByModule2.put(module.getName(), readerAndVersion);
            }
            return readerAndVersion;
        }
        Project project = module.getProject();
        String msg = String.format("Failed to read version for component '%1$s'", componentName);
        msg = reader.isProjectLevel() ? msg + String.format(" for project '%1$s'", project.getName()) : msg + String.format(" for module '%1$s', in project '%2$s'", module.getName(), project.getName());
        VersionCompatibilityChecker.getLogger().info(msg);
        return null;
    }

    private static class ComponentVersionAndReaderCache {
        @NotNull
        final Map<String, Pair<ComponentVersionReader, String>> projectComponents = new HashMap<String, Pair<ComponentVersionReader, String>>();
        @NotNull
        final Map<String, Map<String, Pair<ComponentVersionReader, String>>> moduleComponents = new HashMap<String, Map<String, Pair<ComponentVersionReader, String>>>();

        private ComponentVersionAndReaderCache() {
        }
    }
}

