/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.compatibility.version;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.sync.compatibility.version.ComponentVersionReader;
import com.android.tools.idea.gradle.project.sync.compatibility.version.VersionRange;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.util.PositionInFile;
import com.intellij.openapi.module.Module;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GradleVersionReader
implements ComponentVersionReader {
    GradleVersionReader() {
    }

    @Override
    public boolean appliesTo(@NotNull Module module) {
        return GradleFacet.getInstance(module) != null;
    }

    @Override
    @Nullable
    public String getComponentVersion(@NotNull Module module) {
        GradleVersion gradleVersion2 = GradleVersions.getInstance().getGradleVersion(module.getProject());
        return gradleVersion2 != null ? gradleVersion2.toString() : null;
    }

    @Override
    @Nullable
    public PositionInFile getVersionSource(@NotNull Module module) {
        return null;
    }

    @Override
    @NotNull
    public List<NotificationHyperlink> getQuickFixes(@NotNull Module module, @Nullable VersionRange expectedVersion, @Nullable PositionInFile location) {
        ArrayList<NotificationHyperlink> quickFixes = new ArrayList<NotificationHyperlink>();
        AndroidPluginInfo pluginInfo = AndroidPluginInfo.find(module.getProject());
        if (pluginInfo != null) {
            GradleVersion pluginVersion = GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get());
            GradleVersion gradleVersion2 = GradleVersion.parse((String)"5.4.1");
            String text = "Fix Gradle version (as part of the update, the Android plugin will be updated to version " + pluginVersion + ")";
            quickFixes.add(new FixAndroidGradlePluginVersionHyperlink(text, pluginVersion, gradleVersion2));
        }
        quickFixes.add(new OpenUrlHyperlink("https://developer.android.com/studio/releases/index.html#Revisions", "Open Documentation"));
        return quickFixes;
    }

    @Override
    public boolean isProjectLevel() {
        return true;
    }

    @Override
    @NotNull
    public String getComponentName() {
        return "Gradle";
    }
}

