/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.compatibility.version;

import com.android.ide.common.repository.GradleVersion;
import com.google.common.base.Splitter;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VersionRange {
    @NonNls
    private static final char OR_GREATER = '+';
    @NonNls
    private static final char START_INCLUSIVE = '[';
    @NonNls
    private static final char START_EXCLUSIVE = '(';
    @NonNls
    private static final char END_INCLUSIVE = ']';
    @NonNls
    private static final char END_EXCLUSIVE = ')';
    @NotNull
    private final String myUnparsedValue;
    @NotNull
    private final String myMinVersion;
    @Nullable
    private final GradleVersion myParsedMinVersion;
    private final boolean myMinVersionInclusive;
    @Nullable
    private final String myMaxVersion;
    @Nullable
    private final GradleVersion myParsedMaxVersion;
    private final boolean myMaxVersionInclusive;

    @NotNull
    public static VersionRange parse(@NotNull String value2) {
        if (value2.isEmpty()) {
            throw new IllegalArgumentException("Empty string is not a valid value");
        }
        int size = value2.length();
        char lastChar = value2.charAt(size - 1);
        if (lastChar == '+') {
            String minVersion = value2.substring(0, size - 1);
            return new VersionRange(value2, minVersion, true, null, false);
        }
        char firstChar = value2.charAt(0);
        if (firstChar == '[' || firstChar == '(') {
            boolean minVersionInclusive;
            boolean bl = minVersionInclusive = firstChar == '[';
            if (lastChar != ']' && lastChar != ')') {
                throw new IllegalArgumentException(String.format("Value '%1$s' should end with ']' or ')'", value2));
            }
            boolean maxVersionInclusive = lastChar == ']';
            String rangeValue = value2.substring(1, size - 1);
            List values = Splitter.on((char)',').splitToList((CharSequence)rangeValue);
            if (values.size() != 2) {
                throw new IllegalArgumentException(String.format("Range '%1$s' should contain 2 values", value2));
            }
            String minVersion = ((String)values.get(0)).trim();
            String maxVersion = ((String)values.get(1)).trim();
            if (maxVersion.length() == 1 && maxVersion.charAt(0) == '+') {
                maxVersion = null;
            }
            return new VersionRange(value2, minVersion, minVersionInclusive, maxVersion, maxVersionInclusive);
        }
        return new VersionRange(value2, value2, false, null, false);
    }

    private VersionRange(@NotNull String unparsedValue, @NotNull String minVersion, boolean minVersionInclusive, @Nullable String maxVersion, boolean maxVersionInclusive) {
        this.myUnparsedValue = unparsedValue;
        this.myMinVersion = minVersion;
        GradleVersion parsedMinVersion = GradleVersion.tryParse((String)minVersion);
        if (parsedMinVersion != null && parsedMinVersion.getMajor() == 0 && minVersion.equals(parsedMinVersion.getMajorSegment().getText())) {
            parsedMinVersion = null;
        }
        this.myParsedMinVersion = parsedMinVersion;
        this.myMinVersionInclusive = minVersionInclusive;
        this.myMaxVersion = maxVersion;
        this.myParsedMaxVersion = maxVersion != null ? GradleVersion.tryParse((String)maxVersion) : null;
        this.myMaxVersionInclusive = maxVersionInclusive;
    }

    public boolean contains(@NotNull String value2) {
        if (this.myParsedMinVersion != null) {
            boolean contains = false;
            GradleVersion version2 = GradleVersion.tryParse((String)value2);
            if (version2 != null) {
                if (this.myMinVersionInclusive) {
                    contains = version2.compareIgnoringQualifiers(this.myParsedMinVersion) >= 0;
                } else {
                    boolean bl = contains = version2.compareIgnoringQualifiers(this.myParsedMinVersion) > 0;
                }
                if (contains && this.myParsedMaxVersion != null) {
                    contains = this.myMaxVersionInclusive ? version2.compareIgnoringQualifiers(this.myParsedMaxVersion) <= 0 : version2.compareIgnoringQualifiers(this.myParsedMaxVersion) < 0;
                }
            }
            return contains;
        }
        return value2.equals(this.myMinVersion) || value2.equals(this.myMaxVersion);
    }

    @NotNull
    public String getDescription() {
        if (this.myMinVersion.equals(this.myMaxVersion)) {
            return this.myMinVersion;
        }
        if (this.myMaxVersion == null) {
            return String.format("%1$s (or newer)", this.myMinVersion);
        }
        return "versions " + this.myMinVersion + VersionRange.inclusiveness(this.myMinVersionInclusive) + " to " + this.myMaxVersion + VersionRange.inclusiveness(this.myMaxVersionInclusive);
    }

    private static String inclusiveness(boolean inclusive) {
        return " (" + (inclusive ? "inclusive" : "exclusive") + ")";
    }

    @NotNull
    public String getMinVersion() {
        return this.myMinVersion;
    }

    public boolean isMinVersionInclusive() {
        return this.myMinVersionInclusive;
    }

    @Nullable
    public String getMaxVersion() {
        return this.myMaxVersion;
    }

    public boolean isMaxVersionInclusive() {
        return this.myMaxVersionInclusive;
    }

    public String toString() {
        return this.myUnparsedValue;
    }
}

