/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectionPermissionDeniedErrorHandler
extends BaseSyncErrorHandler {
    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String text = rootCause.getMessage();
        if (rootCause instanceof SocketException && StringUtil.isNotEmpty((String)text) && text.contains("Permission denied: connect")) {
            ConnectionPermissionDeniedErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.CONNECTION_DENIED);
            return "Connection to the Internet denied.";
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        OpenUrlHyperlink quickFix = new OpenUrlHyperlink("https://developer.android.com/studio/troubleshoot.html#project-sync", "More details (and potential fix)");
        hyperlinks.add(quickFix);
        return hyperlinks;
    }
}

