/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.SyncProjectWithExtraCommandLineOptionsHyperlink;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CorruptGradleDependencyErrorHandler
extends BaseSyncErrorHandler {
    @Override
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String text = rootCause.getMessage();
        if (StringUtil.isNotEmpty((String)text) && text.startsWith("Premature end of Content-Length delimited message body")) {
            CorruptGradleDependencyErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.CORRUPT_GRADLE_DEPENDENCY);
            return "Gradle's dependency cache seems to be corrupt or out of sync.";
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        hyperlinks.add(SyncProjectWithExtraCommandLineOptionsHyperlink.syncProjectRefreshingDependencies());
        return hyperlinks;
    }
}

