/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenProjectStructureHyperlink;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DaemonContextMismatchErrorHandler
extends BaseSyncErrorHandler {
    private static final String JAVA_HOME = "javaHome=";

    @Override
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String expectedAndActual;
        String text = rootCause.getMessage();
        List<String> message2 = DaemonContextMismatchErrorHandler.getMessageLines(text);
        if (message2.isEmpty()) {
            return null;
        }
        String firstLine = message2.get(0);
        if (StringUtil.isNotEmpty((String)firstLine) && firstLine.contains("The newly created daemon process has a different context than expected.") && message2.size() > 3 && "Java home is different.".equals(message2.get(2)) && StringUtil.isNotEmpty((String)(expectedAndActual = DaemonContextMismatchErrorHandler.parseExpectedAndActualJavaHomes(text)))) {
            DaemonContextMismatchErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.DAEMON_CONTEXT_MISMATCH);
            return firstLine + "\n" + message2.get(2) + "\n" + expectedAndActual + "\nPlease configure the JDK to match the expected one.";
        }
        return null;
    }

    @VisibleForTesting
    static String parseExpectedAndActualJavaHomes(@NotNull String errorMsg) {
        String expected2;
        int endIndex;
        int startIndex = errorMsg.indexOf(JAVA_HOME);
        if (startIndex != -1 && (endIndex = errorMsg.indexOf(44, startIndex += JAVA_HOME.length())) != -1 && endIndex > startIndex && StringUtil.isNotEmpty((String)(expected2 = errorMsg.substring(startIndex, endIndex)))) {
            String actual = null;
            startIndex = errorMsg.indexOf(JAVA_HOME, endIndex);
            if (startIndex != -1 && (endIndex = errorMsg.indexOf(44, startIndex += JAVA_HOME.length())) != -1 && endIndex > startIndex) {
                actual = errorMsg.substring(startIndex, endIndex);
            }
            String s = String.format("Expecting: '%1$s'", expected2);
            s = actual != null ? s + String.format(" but was: '%1$s'.", actual) : s + ".";
            return s;
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        hyperlinks.add(OpenProjectStructureHyperlink.openJdkSettings(project));
        return hyperlinks;
    }
}

