/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.GradleDistributionInstallErrorHandler;
import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.idea.ProjectImportErrorHandler;
import com.android.tools.idea.util.PositionInFile;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.regex.Matcher;
import org.gradle.tooling.GradleConnectionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ErrorAndLocation {
    @NotNull
    private final ExternalSystemException myError;
    @Nullable
    private final PositionInFile myPositionInFile;

    @VisibleForTesting
    ErrorAndLocation(@NotNull ExternalSystemException error, @Nullable PositionInFile positionInFile) {
        this.myError = error;
        this.myPositionInFile = positionInFile;
    }

    @NotNull
    ExternalSystemException getError() {
        return this.myError;
    }

    @Nullable
    PositionInFile getPositionInFile() {
        return this.myPositionInFile;
    }

    static class Factory {
        Factory() {
        }

        @NotNull
        ErrorAndLocation create(@NotNull Throwable error) {
            Throwable rootCause = error;
            String location = null;
            while (true) {
                String msg;
                Matcher matcher;
                LocationAwareExternalSystemException ex;
                VirtualFile errorFile;
                if (rootCause instanceof LocationAwareExternalSystemException && (errorFile = VfsUtil.findFileByIoFile((File)new File((ex = (LocationAwareExternalSystemException)rootCause).getFilePath()), (boolean)true)) != null) {
                    return new ErrorAndLocation(Factory.createErrorToReport(rootCause), new PositionInFile(errorFile, ex.getLine(), ex.getColumn()));
                }
                if (rootCause instanceof GradleConnectionException && (matcher = GradleDistributionInstallErrorHandler.COULD_NOT_INSTALL_GRADLE_DISTRIBUTION_PATTERN.matcher(msg = rootCause.getMessage())).matches()) {
                    location = Factory.getLocationFrom(rootCause);
                    break;
                }
                if (location == null) {
                    location = Factory.getLocationFrom(rootCause);
                }
                if (rootCause.getCause() == null || rootCause.getCause().getMessage() == null) break;
                rootCause = rootCause.getCause();
            }
            PositionInFile positionInFile = Factory.createPositionInFile(location);
            return new ErrorAndLocation(Factory.createErrorToReport(rootCause), positionInFile);
        }

        @NotNull
        private static ExternalSystemException createErrorToReport(@NotNull Throwable rootCause) {
            String errMessage = ProjectImportErrorHandler.createErrorMessage(rootCause);
            ExternalSystemException exception = new ExternalSystemException(errMessage);
            exception.initCause(rootCause);
            return exception;
        }

        @Nullable
        private static String getLocationFrom(@NotNull Throwable error) {
            String location;
            String errorToString = error.toString();
            if (errorToString.contains("LocationAwareException") && (location = error.getMessage()) != null && (location.startsWith("Build file '") || location.startsWith("Settings file '"))) {
                String[] lines = StringUtil.splitByLines((String)location);
                return lines.length > 0 ? lines[0] : null;
            }
            return null;
        }

        @Nullable
        private static PositionInFile createPositionInFile(@Nullable String location) {
            VirtualFile errorFile;
            Pair<String, Integer> pair;
            if (StringUtil.isNotEmpty((String)location) && (pair = SyncErrorHandler.getErrorLocation(location)) != null && (errorFile = VfsUtil.findFileByIoFile((File)new File((String)pair.getFirst()), (boolean)true)) != null) {
                return new PositionInFile(errorFile, (Integer)pair.getSecond(), -1);
            }
            return null;
        }
    }
}

