/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.SyncProjectWithExtraCommandLineOptionsHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ErrorOpeningZipFileErrorHandler
extends SyncErrorHandler {
    @Override
    public boolean handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        String text = this.findErrorMessage(project, this.getRootCause(error));
        if (text != null) {
            ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
            NotificationHyperlink syncProjectHyperlink = SyncProjectWithExtraCommandLineOptionsHyperlink.syncProjectRefreshingDependencies();
            hyperlinks.add(syncProjectHyperlink);
            GradleSyncMessages.getInstance(project).updateNotification(notification, text, hyperlinks);
            return true;
        }
        return false;
    }

    private String findErrorMessage(@NotNull Project project, @NotNull Throwable rootCause) {
        String text = rootCause.getMessage();
        if (StringUtil.isNotEmpty((String)text) && text.contains("error in opening zip file")) {
            ErrorOpeningZipFileErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.CANNOT_OPEN_ZIP_FILE);
            return "Failed to open zip file.\nGradle's dependency cache may be corrupt (this sometimes occurs after a network connection timeout.)";
        }
        return null;
    }
}

