/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.sdk.AndroidSdks;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FailedToParseSdkErrorHandler
extends BaseSyncErrorHandler {
    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String text = rootCause.getMessage();
        if (rootCause instanceof RuntimeException && StringUtil.isNotEmpty((String)text) && text.contains("failed to parse SDK")) {
            String newMsg;
            text = text + "\n\nThe Android SDK may be missing the directory 'add-ons'.";
            File pathOfBrokenSdk = AndroidSdks.getInstance().findPathOfSdkWithoutAddonsFolder(project);
            if (pathOfBrokenSdk != null) {
                newMsg = String.format("The directory '%1$s', in the Android SDK at '%2$s', is either missing or empty", "add-ons", pathOfBrokenSdk.getPath());
                if (!pathOfBrokenSdk.canWrite()) {
                    String format = "\n\nCurrent user (%1$s) does not have write access to the SDK directory.";
                    newMsg = newMsg + String.format(format, SystemProperties.getUserName());
                }
            } else {
                newMsg = FailedToParseSdkErrorHandler.getFirstLineMessage(text);
            }
            FailedToParseSdkErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.FAILED_TO_PARSE_SDK);
            return newMsg;
        }
        return null;
    }
}

