/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GenericErrorHandler
extends SyncErrorHandler {
    @Override
    public boolean handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        List<NotificationHyperlink> hyperlinks;
        String text = this.getRootCause(error).getMessage();
        if (text != null && !(hyperlinks = this.getQuickFixHyperlinks(notification, text)).isEmpty()) {
            GenericErrorHandler.updateUsageTracker(project, null);
            GradleSyncMessages.getInstance(project).updateNotification(notification, text, hyperlinks);
            return true;
        }
        return false;
    }

    @NotNull
    private List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull NotificationData notification, @NotNull String text) {
        String lastLine;
        Pair<String, Integer> errorLocation;
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        List<String> message2 = GenericErrorHandler.getMessageLines(text);
        if (!message2.isEmpty() && (errorLocation = GenericErrorHandler.getErrorLocation(lastLine = message2.get(message2.size() - 1))) != null) {
            String filePath = (String)errorLocation.getFirst();
            int line = (Integer)errorLocation.getSecond();
            hyperlinks.add(new OpenFileHyperlink(filePath, line - 1));
            return hyperlinks;
        }
        String filePath = notification.getFilePath();
        if (StringUtil.isNotEmpty((String)filePath)) {
            int lineIndex = notification.getLine() - 1;
            int column = notification.getColumn();
            hyperlinks.add(new OpenFileHyperlink(filePath, "Open File", lineIndex, column));
        }
        return hyperlinks;
    }
}

