/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.DeleteFileAndSyncHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.StartParameter;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.WrapperConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class GradleDistributionInstallErrorHandler
extends SyncErrorHandler {
    public static final Pattern COULD_NOT_INSTALL_GRADLE_DISTRIBUTION_PATTERN = Pattern.compile("Could not install Gradle distribution from '(.*?)'.");

    @Override
    public boolean handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        PathAssembler.LocalDistribution localDistribution;
        File zip;
        String msg = error.getMessage();
        if (msg == null) {
            return false;
        }
        Matcher matcher = COULD_NOT_INSTALL_GRADLE_DISTRIBUTION_PATTERN.matcher(msg);
        if (!matcher.matches()) {
            return false;
        }
        StringBuilder text = new StringBuilder(msg);
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        WrapperConfiguration wrapperConfiguration = GradleUtil.getWrapperConfiguration((String)project.getBasePath());
        if (wrapperConfiguration != null && (zip = (localDistribution = new PathAssembler(StartParameter.DEFAULT_GRADLE_USER_HOME).getDistribution(wrapperConfiguration)).getZipFile()).exists()) {
            try {
                zip = zip.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            text.append("\nThe cached zip file ").append(zip).append(" may be corrupted.");
            hyperlinks.add(new DeleteFileAndSyncHyperlink(zip, GradleSyncStats.Trigger.TRIGGER_QF_GRADLE_DISTRIBUTION_DELETED));
        }
        GradleSyncMessages.getInstance(project).updateNotification(notification, text.toString(), hyperlinks);
        GradleDistributionInstallErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.GRADLE_DISTRIBUTION_INSTALL_ERROR);
        return true;
    }
}

