/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.ToggleOfflineModeHyperlink;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InternetConnectionErrorHandler
extends BaseSyncErrorHandler {
    @Override
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String text = rootCause.getMessage();
        String firstLine = InternetConnectionErrorHandler.getFirstLineMessage(text);
        if (StringUtil.isNotEmpty((String)firstLine) && (firstLine.startsWith("Could not GET ") || firstLine.startsWith("Could not HEAD ") || firstLine.startsWith("Network is unreachable"))) {
            InternetConnectionErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.INTERNET_CONNECTION_ERROR);
            return text;
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        ToggleOfflineModeHyperlink enableOfflineMode = ToggleOfflineModeHyperlink.enableOfflineMode(project);
        if (enableOfflineMode != null) {
            hyperlinks.add(enableOfflineMode);
        }
        return hyperlinks;
    }
}

