/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.Jdks;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class Jdk8RequiredErrorHandler
extends BaseSyncErrorHandler {
    @NotNull
    private final Jdks myJdks;

    public Jdk8RequiredErrorHandler(@NotNull Jdks jdks) {
        this.myJdks = jdks;
    }

    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String text = rootCause.getMessage();
        if (StringUtil.isNotEmpty((String)text) && text.contains("Unsupported major.minor version 52.0")) {
            if (!text.endsWith(".")) {
                text = text + ".";
            }
            text = text + " Please use JDK 8 or newer.";
            Jdk8RequiredErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.JDK8_REQUIRED);
            return text;
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        return this.myJdks.getWrongJdkQuickFixes(project);
    }
}

