/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.AddGoogleMavenRepositoryHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenPluginBuildFileHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingAndroidPluginErrorHandler
extends BaseSyncErrorHandler {
    private static final String PATTERN = "Could not find com.android.tools.build:gradle:";

    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String text = rootCause.getMessage();
        if (text.startsWith(PATTERN)) {
            return text;
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        if (project.isInitialized()) {
            List<VirtualFile> buildFiles = AddGoogleMavenRepositoryHyperlink.getBuildFileForPlugin(project);
            if (!buildFiles.isEmpty() && buildFiles.get(0) != null) {
                GradleBuildModel gradleBuildModel;
                ProjectBuildModel projectBuildModel;
                VirtualFile buildFile = buildFiles.get(0);
                if (!GradleUtil.isKtsFile(buildFile) && (projectBuildModel = ProjectBuildModel.getOrLog(project)) != null && !(gradleBuildModel = projectBuildModel.getModuleBuildModel(buildFile)).buildscript().repositories().hasGoogleMavenRepository()) {
                    hyperlinks.add(new AddGoogleMavenRepositoryHyperlink((List<VirtualFile>)ImmutableList.of((Object)buildFile)));
                }
                hyperlinks.add(new OpenFileHyperlink(FileUtil.toSystemDependentName((String)buildFile.getPath())));
            }
        } else {
            hyperlinks.add(new AddGoogleMavenRepositoryHyperlink(project));
            hyperlinks.add(new OpenPluginBuildFileHyperlink());
        }
        return hyperlinks;
    }
}

