/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallBuildToolsHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingBuildToolsErrorHandler
extends BaseSyncErrorHandler {
    private final Pattern MISSING_BUILD_TOOLS_PATTERN = Pattern.compile("(Cause: )?([Ff])ailed to find Build Tools revision (.*)");

    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String text = rootCause.getMessage();
        if (StringUtil.isNotEmpty((String)text)) {
            Matcher matcher = this.MISSING_BUILD_TOOLS_PATTERN.matcher(MissingBuildToolsErrorHandler.getFirstLineMessage(text));
            if ((rootCause instanceof IllegalStateException || rootCause instanceof ExternalSystemException) && matcher.matches()) {
                MissingBuildToolsErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.MISSING_BUILD_TOOLS);
                return text;
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        Matcher matcher = this.MISSING_BUILD_TOOLS_PATTERN.matcher(MissingBuildToolsErrorHandler.getFirstLineMessage(text));
        if (matcher.matches()) {
            String version2 = matcher.group(3);
            GradleVersion currentAGPVersion = null;
            AndroidPluginInfo result2 = AndroidPluginInfo.findFromBuildFiles(project);
            if (result2 != null) {
                currentAGPVersion = result2.getPluginVersion();
            }
            GradleVersion recommendedAGPVersion = GradleVersion.tryParseAndroidGradlePluginVersion((String)LatestKnownPluginVersionProvider.INSTANCE.get());
            return MissingBuildToolsErrorHandler.getQuickFixHyperlinks(version2, currentAGPVersion, recommendedAGPVersion, GradleUtil.hasKtsBuildFiles(project));
        }
        return Collections.emptyList();
    }

    static List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull String version2, @Nullable GradleVersion currentAGPVersion, @Nullable GradleVersion recommendedAGPVersion, boolean hasKTSBuildFiles) {
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        hyperlinks.add(new InstallBuildToolsHyperlink(version2));
        if (hasKTSBuildFiles) {
            return hyperlinks;
        }
        if (currentAGPVersion == null || recommendedAGPVersion == null || currentAGPVersion.compareTo(recommendedAGPVersion) < 0) {
            hyperlinks.add(new FixAndroidGradlePluginVersionHyperlink());
        }
        return hyperlinks;
    }
}

