/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallCMakeHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.SetCmakeDirHyperlink;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingCMakeErrorHandler
extends BaseSyncErrorHandler {
    private static final String FORK_CMAKE_SDK_VERSION = "3.6.4111459";
    private static final String FORK_CMAKE_REPORTED_VERSION = "3.6.0";
    private static final Revision ourForkCmakeSdkVersion = Revision.parseRevision((String)"3.6.4111459");
    private static final Revision ourForkCmakeReportedVersion = Revision.parseRevision((String)"3.6.0");

    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String message2 = rootCause.getMessage();
        if (StringUtil.isNotEmpty((String)message2)) {
            String firstLine = MissingCMakeErrorHandler.getFirstLineMessage(message2);
            if (firstLine.startsWith("Failed to find CMake.") || firstLine.startsWith("Unable to get the CMake version")) {
                MissingCMakeErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.MISSING_CMAKE);
                return "Failed to find CMake.";
            }
            if (MissingCMakeErrorHandler.matchesCannotFindCmake(firstLine) || MissingCMakeErrorHandler.matchesTriedInstall(message2) || MissingCMakeErrorHandler.matchesCmakeWithVersion(message2)) {
                MissingCMakeErrorHandler.updateUsageTracker(project, null);
                return message2;
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        String firstLine = MissingCMakeErrorHandler.getFirstLineMessage(text);
        String version2 = MissingCMakeErrorHandler.extractCmakeVersionFromError(firstLine);
        if (version2 != null) {
            RevisionOrHigher requestedCmake = MissingCMakeErrorHandler.parseRevisionOrHigher(version2, firstLine);
            if (requestedCmake == null) {
                return Collections.emptyList();
            }
            RepoManager sdkManager = this.getSdkManager();
            Collection remoteCmakePackages = sdkManager.getPackages().getRemotePackagesForPrefix("cmake");
            Revision foundCmakeVersion = MissingCMakeErrorHandler.findBestMatch(remoteCmakePackages, requestedCmake);
            if (foundCmakeVersion == null) {
                return Collections.emptyList();
            }
            Collection localCmakePackages = sdkManager.getPackages().getLocalPackagesForPrefix("cmake");
            File alreadyInstalledCmake = MissingCMakeErrorHandler.getAlreadyInstalled(localCmakePackages, foundCmakeVersion);
            if (alreadyInstalledCmake != null) {
                try {
                    File cmakeDir = this.getLocalPropertiesCMakeDir(project);
                    if (cmakeDir == null) {
                        return Collections.singletonList(new SetCmakeDirHyperlink(alreadyInstalledCmake, String.format("Set cmake.dir in local.properties to %s", alreadyInstalledCmake)));
                    }
                    if (cmakeDir.getPath() == alreadyInstalledCmake.getPath()) {
                        return Collections.emptyList();
                    }
                    return Collections.singletonList(new SetCmakeDirHyperlink(alreadyInstalledCmake, String.format("Replace cmake.dir in local.properties with %s", alreadyInstalledCmake)));
                }
                catch (IOException e) {
                    return Collections.emptyList();
                }
            }
            return Collections.singletonList(new InstallCMakeHyperlink(foundCmakeVersion));
        }
        return Collections.singletonList(new InstallCMakeHyperlink());
    }

    private static boolean matchesCmakeWithVersion(@NotNull String firstLine) {
        return firstLine.startsWith("Unable to find CMake with version:");
    }

    private static boolean matchesCannotFindCmake(@NotNull String firstLine) {
        return firstLine.startsWith("CMake") && firstLine.contains("was not found in PATH or by cmake.dir property");
    }

    private static boolean matchesTriedInstall(@NotNull String errorMessage) {
        return !(!errorMessage.startsWith("Failed to install the following Android SDK packages as some licences have not been accepted.") && !errorMessage.startsWith("Failed to install the following SDK components:") || !errorMessage.contains("CMake") && !errorMessage.contains("cmake"));
    }

    @Nullable
    @VisibleForTesting
    static String extractCmakeVersionFromError(@NotNull String firstLine) {
        String revision = MissingCMakeErrorHandler.extractCmakeVersionFromErrorInTicks(firstLine);
        if (revision != null) {
            return revision;
        }
        return MissingCMakeErrorHandler.extractCmakeVersionFromErrorInVersionWithin(firstLine);
    }

    @Nullable
    @VisibleForTesting
    static RevisionOrHigher parseRevisionOrHigher(String version2, String firstLine) {
        try {
            return new RevisionOrHigher(Revision.parseRevision((String)version2), firstLine.contains("'" + version2 + "' or higher"));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    private static String extractCmakeVersionFromErrorInTicks(@NotNull String firstLine) {
        int startPos = firstLine.indexOf(39);
        if (startPos == -1) {
            return null;
        }
        int endPos = firstLine.indexOf(39, startPos + 1);
        if (endPos == -1) {
            return null;
        }
        return firstLine.substring(startPos + 1, endPos);
    }

    @Nullable
    private static String extractCmakeVersionFromErrorInVersionWithin(@NotNull String firstLine) {
        int startPos = firstLine.indexOf("version: ");
        if (startPos == -1) {
            return null;
        }
        int endPos = firstLine.indexOf(" within", startPos + 1);
        if (endPos == -1) {
            return null;
        }
        return firstLine.substring(startPos + 9, endPos);
    }

    @Nullable
    @VisibleForTesting
    static Revision findBestMatch(@NotNull Collection<RemotePackage> cmakePackages, @NotNull RevisionOrHigher requestedCmake) {
        Revision foundVersion = null;
        for (RemotePackage remotePackage : cmakePackages) {
            Revision remoteCmake = remotePackage.getVersion();
            if (remoteCmake.equals((Object)ourForkCmakeSdkVersion)) {
                remoteCmake = ourForkCmakeReportedVersion;
            }
            if (!MissingCMakeErrorHandler.versionSatisfies(remoteCmake, requestedCmake)) continue;
            if (foundVersion == null) {
                foundVersion = remoteCmake;
                continue;
            }
            if (remoteCmake.compareTo(foundVersion, Revision.PreviewComparison.IGNORE) <= 0) continue;
            foundVersion = remoteCmake;
        }
        return foundVersion;
    }

    @VisibleForTesting
    static boolean versionSatisfies(@NotNull Revision candidateCmake, @NotNull RevisionOrHigher requestedCmake) {
        int result2 = candidateCmake.compareTo(requestedCmake.revision, Revision.PreviewComparison.IGNORE);
        return result2 == 0 || requestedCmake.orHigher && result2 >= 0;
    }

    @Nullable
    private static File getAlreadyInstalled(@NotNull Collection<LocalPackage> cmakePackages, @NotNull Revision cmakeVersion) {
        for (LocalPackage localCmakePackage : cmakePackages) {
            if (!localCmakePackage.getVersion().equals((Object)cmakeVersion)) continue;
            return localCmakePackage.getLocation();
        }
        return null;
    }

    @NotNull
    protected RepoManager getSdkManager() {
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        StudioLoggerProgressIndicator progressIndicator = new StudioLoggerProgressIndicator(this.getClass());
        return sdkHandler.getSdkManager((ProgressIndicator)progressIndicator);
    }

    @Nullable
    protected File getLocalPropertiesCMakeDir(Project project) throws IOException {
        return new LocalProperties(project).getAndroidCmakePath();
    }

    static class RevisionOrHigher {
        @NotNull
        public final Revision revision;
        public final boolean orHigher;

        public RevisionOrHigher(@NotNull Revision revision, boolean orHigher) {
            this.revision = revision;
            this.orHigher = orHigher;
        }
    }
}

