/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallNdkHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.SetNdkDirHyperlink;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingNdkErrorHandler
extends BaseSyncErrorHandler {
    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String message2 = rootCause.getMessage();
        if (StringUtil.isNotEmpty((String)message2) && MissingNdkErrorHandler.matchesNdkNotConfigured(MissingNdkErrorHandler.getFirstLineMessage(message2))) {
            MissingNdkErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.NDK_NOT_CONFIGURED);
            return "NDK not configured.";
        }
        if (StringUtil.isNotEmpty((String)message2) && MissingNdkErrorHandler.matchesTriedInstall(message2)) {
            MissingNdkErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.FAILED_TO_INSTALL_NDK_BUNDLE);
            return message2;
        }
        return null;
    }

    private static boolean matchesNdkNotConfigured(@NotNull String errorMessage) {
        return errorMessage.startsWith("NDK not configured.") || errorMessage.startsWith("NDK location not found.");
    }

    private static boolean matchesTriedInstall(@NotNull String errorMessage) {
        return (errorMessage.startsWith("Failed to install the following Android SDK packages as some licences have not been accepted.") || errorMessage.startsWith("Failed to install the following SDK components:")) && errorMessage.contains("ndk-bundle NDK");
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        File ndkPath = IdeSdks.getInstance().getAndroidNdkPath();
        if (ndkPath != null) {
            File localSettingsNdkDir;
            try {
                localSettingsNdkDir = this.getLocalPropertiesNdkDir(project);
            }
            catch (IOException e) {
                return Collections.emptyList();
            }
            if (localSettingsNdkDir == null) {
                return Collections.singletonList(new SetNdkDirHyperlink(ndkPath, String.format("Set ndk.dir in local.properties to %s", ndkPath)));
            }
            if (ndkPath.getPath() == localSettingsNdkDir.getPath()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(new SetNdkDirHyperlink(ndkPath, String.format("Replace ndk.dir in local.properties with %s", ndkPath)));
        }
        return Collections.singletonList(new InstallNdkHyperlink());
    }

    @Nullable
    protected File getLocalPropertiesNdkDir(Project project) throws IOException {
        return new LocalProperties(project).getAndroidNdkPath();
    }
}

