/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NdkToolchainMissingABIHandler
extends BaseSyncErrorHandler {
    @NotNull
    private static final String ERROR_MESSAGE = "No toolchains found in the NDK toolchains folder for ABI with prefix: ";
    @NotNull
    private static final List<String> VALID_ABIS = Arrays.asList("mips64el-linux-android", "mipsel-linux-android");

    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        boolean valid;
        String text = rootCause.getMessage();
        if (text.startsWith(ERROR_MESSAGE) && (valid = VALID_ABIS.stream().anyMatch(it -> text.endsWith((String)it))) && !NdkToolchainMissingABIHandler.isArtifactVersionOver3dot0(NdkToolchainMissingABIHandler.getAndroidPluginArtifactModel(project))) {
            return text + "\nThis version of the NDK may be incompatible with the Android Gradle plugin version 3.0 or older.\nPlease use plugin version 3.1 or newer.";
        }
        return null;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        if (!NdkToolchainMissingABIHandler.isArtifactVersionOver3dot0(NdkToolchainMissingABIHandler.getAndroidPluginArtifactModel(project)) && !GradleUtil.hasKtsBuildFiles(project)) {
            return Collections.singletonList(new FixAndroidGradlePluginVersionHyperlink());
        }
        return super.getQuickFixHyperlinks(project, text);
    }

    private static boolean isArtifactVersionOver3dot0(@Nullable ArtifactDependencyModel artifactModel) {
        if (artifactModel == null) {
            return false;
        }
        String version2 = artifactModel.version().toString();
        if (version2 == null) {
            return false;
        }
        GradleCoordinate versionOnly = GradleCoordinate.parseVersionOnly((String)version2);
        return versionOnly.getMajorVersion() >= 3 && versionOnly.getMinorVersion() > 0;
    }

    @Nullable
    private static ArtifactDependencyModel getAndroidPluginArtifactModel(@NotNull Project project) {
        ProjectBuildModel projectBuildModel = ProjectBuildModel.getOrLog(project);
        if (projectBuildModel == null) {
            return null;
        }
        GradleBuildModel rootModel = projectBuildModel.getProjectBuildModel();
        if (rootModel != null) {
            List<ArtifactDependencyModel> dependencyModels = rootModel.buildscript().dependencies().artifacts();
            return dependencyModels.stream().filter(dependency -> NdkToolchainMissingABIHandler.isAndroidPlugin(dependency)).findFirst().orElse(null);
        }
        return null;
    }

    private static boolean isAndroidPlugin(@NotNull ArtifactDependencyModel artifactModel) {
        String group = artifactModel.group().toString();
        String name = artifactModel.name().toString();
        return group != null && name != null && group.equals("com.android.tools.build") && name.equals("gradle");
    }
}

