/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.BuildProjectHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenAndroidSdkManagerHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ObjectStreamErrorHandler
extends SyncErrorHandler {
    @Override
    public boolean handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        String text = ObjectStreamErrorHandler.findErrorMessage(project, error);
        if (text != null) {
            ObjectStreamErrorHandler.findAndAddQuickFixes(notification, project, text);
            return true;
        }
        return false;
    }

    private static String findErrorMessage(@NotNull Project project, @NotNull Throwable rootCause) {
        String text = rootCause.getMessage();
        if (StringUtil.isNotEmpty((String)text) && ObjectStreamErrorHandler.getFirstLineMessage(text).endsWith("unexpected end of block data")) {
            ObjectStreamErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.OBJECT_STREAM_ERROR);
            String newMsg = "An unexpected I/O error occurred.\n";
            newMsg = newMsg + String.format("The error, \"%1$s\" usually happens on Linux when Build-tools or an Android platform being used in a project is not installed.\n", text);
            return newMsg;
        }
        return null;
    }

    private static void findAndAddQuickFixes(@NotNull NotificationData notification, @NotNull Project project, @NotNull String text) {
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        BuildProjectHyperlink buildProjectHyperlink = new BuildProjectHyperlink();
        OpenAndroidSdkManagerHyperlink openAndroidSdkManagerHyperlink = new OpenAndroidSdkManagerHyperlink();
        text = text + "Please try one of the following:\n" + buildProjectHyperlink.toHtml() + " to obtain the cause of the error\n\n" + openAndroidSdkManagerHyperlink.toHtml() + " to check if there are any missing components";
        hyperlinks.add(buildProjectHyperlink);
        hyperlinks.add(openAndroidSdkManagerHyperlink);
        notification.setTitle("Gradle Sync Issues");
        notification.setMessage(text);
        notification.setNotificationCategory(NotificationCategory.convert((NotificationType)DEFAULT_NOTIFICATION_TYPE));
        GradleSyncMessages.getInstance(project).addNotificationListener(notification, hyperlinks);
    }
}

