/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenPluginBuildFileHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class OldAndroidPluginErrorHandler
extends BaseSyncErrorHandler {
    private static final Pattern PATTERN = Pattern.compile("The android gradle plugin version .+ is too old, please update to the latest version.");

    @Override
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull Project project) {
        String text = rootCause.getMessage();
        if (OldAndroidPluginErrorHandler.isMatching(text)) {
            OldAndroidPluginErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.OLD_ANDROID_PLUGIN);
            return Joiner.on((char)'\n').join((Iterable)Splitter.on((char)'\n').omitEmptyStrings().trimResults().splitToList((CharSequence)text));
        }
        return null;
    }

    @VisibleForTesting
    static boolean isMatching(String text) {
        if (StringUtil.isNotEmpty((String)text)) {
            String firstLine = OldAndroidPluginErrorHandler.getFirstLineMessage(text);
            if (firstLine.startsWith("Plugin is too old, please update to a more recent version")) {
                return true;
            }
            return PATTERN.matcher(firstLine).matches();
        }
        return false;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        if (!GradleUtil.hasKtsBuildFiles(project)) {
            hyperlinks.add(new FixAndroidGradlePluginVersionHyperlink());
        }
        if (project.isInitialized()) {
            AndroidPluginInfo result2 = AndroidPluginInfo.findFromBuildFiles(project);
            if (result2 != null && result2.getPluginBuildFile() != null) {
                hyperlinks.add(new OpenFileHyperlink(result2.getPluginBuildFile().getPath()));
            }
        } else {
            hyperlinks.add(new OpenPluginBuildFileHyperlink());
        }
        return hyperlinks;
    }
}

