/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.ide.common.repository.GradleVersion;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixBuildToolsVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.InstallBuildToolsHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;

public class SdkBuildToolsTooLowErrorHandler
extends SyncErrorHandler {
    private static final Pattern SDK_BUILD_TOOLS_TOO_LOW_PATTERN = Pattern.compile("The SDK Build Tools revision \\((.*)\\) is too low for project '(.*)'. Minimum required is (.*)");

    @NotNull
    public static SdkBuildToolsTooLowErrorHandler getInstance() {
        for (SyncErrorHandler errorHandler : SyncErrorHandler.getExtensions()) {
            if (!(errorHandler instanceof SdkBuildToolsTooLowErrorHandler)) continue;
            return (SdkBuildToolsTooLowErrorHandler)errorHandler;
        }
        throw new IllegalStateException("Unable to find an instance of " + SdkBuildToolsTooLowErrorHandler.class.getName());
    }

    @Override
    public boolean handleError(@NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        String text = this.getRootCause(error).getMessage();
        List<NotificationHyperlink> hyperlinks = this.getQuickFixHyperlinks(project, text);
        if (!hyperlinks.isEmpty()) {
            SdkBuildToolsTooLowErrorHandler.updateUsageTracker(project, AndroidStudioEvent.GradleSyncFailure.SDK_BUILD_TOOLS_TOO_LOW);
            GradleSyncMessages.getInstance(project).updateNotification(notification, text, hyperlinks);
            return true;
        }
        return false;
    }

    @NotNull
    private List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @NotNull String text) {
        Matcher matcher = SDK_BUILD_TOOLS_TOO_LOW_PATTERN.matcher(SdkBuildToolsTooLowErrorHandler.getFirstLineMessage(text));
        if (matcher.matches()) {
            String gradlePath = matcher.group(2);
            Module module = GradleUtil.findModuleByGradlePath(project, gradlePath);
            String minimumVersion = matcher.group(3);
            VirtualFile file = module == null ? null : GradleUtil.getGradleBuildFile(module);
            ImmutableMap buildFileMap = module != null && file != null ? ImmutableMap.of((Object)module, (Object)file) : ImmutableMap.of();
            List<NotificationHyperlink> links = this.getQuickFixHyperlinks(minimumVersion, (List<Module>)(file == null ? ImmutableList.of() : ImmutableList.of((Object)module)), (Map<Module, VirtualFile>)buildFileMap);
            if (file != null) {
                links.add(new OpenFileHyperlink(file.getPath()));
            }
            return links;
        }
        return Collections.emptyList();
    }

    private static boolean doesAndroidGradlePluginPackageBuildTools(@NotNull List<Module> modules) {
        for (Module module : modules) {
            GradleVersion agpVersion;
            AndroidPluginInfo pluginInfo;
            if (AndroidFacet.getInstance(module) == null || (pluginInfo = AndroidPluginInfo.find(module.getProject())) == null || (agpVersion = pluginInfo.getPluginVersion()) == null || agpVersion.isAtLeast(3, 0, 0)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull String minimumVersion, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        boolean buildToolInstalled = false;
        AndroidSdkHandler sdkHandler = null;
        AndroidSdkData androidSdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (androidSdkData != null) {
            sdkHandler = androidSdkData.getSdkHandler();
        }
        if (sdkHandler != null) {
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(SdkBuildToolsTooLowErrorHandler.class);
            RepositoryPackages packages = sdkHandler.getSdkManager((ProgressIndicator)progress).getPackages();
            LocalPackage buildTool = (LocalPackage)packages.getLocalPackages().get(DetailsTypes.getBuildToolsPath((Revision)Revision.parseRevision((String)minimumVersion)));
            buildToolInstalled = buildTool != null;
        }
        List<VirtualFile> buildFiles = affectedModules.stream().map(m -> (VirtualFile)buildFileMap.get(m)).filter(Objects::nonNull).collect(Collectors.toList());
        if (!buildToolInstalled) {
            hyperlinks.add(new InstallBuildToolsHyperlink(minimumVersion, buildFiles, SdkBuildToolsTooLowErrorHandler.doesAndroidGradlePluginPackageBuildTools(affectedModules)));
        } else if (!buildFiles.isEmpty()) {
            hyperlinks.add(new FixBuildToolsVersionHyperlink(minimumVersion, buildFiles, SdkBuildToolsTooLowErrorHandler.doesAndroidGradlePluginPackageBuildTools(affectedModules)));
        }
        return hyperlinks;
    }
}

