/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.ErrorAndLocation;
import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.util.PositionInFile;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.pom.NonNavigatable;
import org.jetbrains.annotations.NotNull;

public class SyncErrorHandlerManager {
    @NotNull
    private final GradleSyncMessages mySyncMessages;
    @NotNull
    private final ErrorAndLocation.Factory myCauseAndLocationFactory;
    @NotNull
    private final SyncErrorHandler[] myErrorHandlers;
    @NotNull
    private final Project myProject;

    public SyncErrorHandlerManager(@NotNull Project project) {
        this(project, GradleSyncMessages.getInstance(project), new ErrorAndLocation.Factory(), SyncErrorHandler.getExtensions());
    }

    @VisibleForTesting
    SyncErrorHandlerManager(@NotNull Project project, @NotNull GradleSyncMessages syncMessages, @NotNull ErrorAndLocation.Factory causeAndLocationFactory, SyncErrorHandler ... errorHandlers) {
        this.mySyncMessages = syncMessages;
        this.myCauseAndLocationFactory = causeAndLocationFactory;
        this.myErrorHandlers = errorHandlers;
        this.myProject = project;
    }

    public void handleError(@NotNull Throwable error) {
        Runnable runnable = () -> {
            ErrorAndLocation errorAndLocation = this.myCauseAndLocationFactory.create(error);
            ExternalSystemException errorToReport = errorAndLocation.getError();
            String message2 = ExternalSystemApiUtil.buildErrorMessage((Throwable)errorToReport);
            PositionInFile positionInFile = errorAndLocation.getPositionInFile();
            NotificationData notificationData = this.mySyncMessages.createNotification("Gradle Sync Issues", message2, NotificationCategory.ERROR, positionInFile);
            for (SyncErrorHandler errorHandler : this.myErrorHandlers) {
                if (errorHandler.handleError(errorToReport, notificationData, this.myProject)) break;
            }
            if (notificationData.getNavigatable() == null) {
                notificationData.setNavigatable(NonNavigatable.INSTANCE);
            }
            this.mySyncMessages.report(notificationData);
        };
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(runnable);
    }
}

