/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class DeleteFileAndSyncHyperlink
extends NotificationHyperlink {
    @NotNull
    private File myFile;
    @NotNull
    private GradleSyncStats.Trigger myTrigger;

    public DeleteFileAndSyncHyperlink(@NotNull File file, @NotNull GradleSyncStats.Trigger trigger) {
        super("deleteFileAndSync", "Delete file and sync project");
        this.myFile = file;
        this.myTrigger = trigger;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (Messages.showYesNoDialog((Project)project, (String)("Are you sure you want to delete this file?\n\n" + this.myFile.getPath()), (String)"Delete File", null) == 0) {
            if (FileUtil.delete((File)this.myFile)) {
                GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, this.myTrigger);
            } else {
                Messages.showErrorDialog((Project)project, (String)("Could not delete " + this.myFile.getPath()), (String)"Delete File");
            }
        }
    }

    @VisibleForTesting
    @NotNull
    public File getFile() {
        return this.myFile;
    }
}

