/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.repository.Revision;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.issues.processor.FixBuildToolsProcessor;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InstallBuildToolsHyperlink
extends NotificationHyperlink {
    @NotNull
    private final String myVersion;
    @NotNull
    private final List<VirtualFile> myBuildFiles;
    private final boolean myRemoveBuildTools;

    public InstallBuildToolsHyperlink(@NotNull String version2) {
        this(version2, (List<VirtualFile>)ImmutableList.of(), false);
    }

    public InstallBuildToolsHyperlink(@NotNull String version2, @NotNull List<VirtualFile> buildFiles, boolean removeBuildTools) {
        super("install.build.tools", InstallBuildToolsHyperlink.getText(version2, !buildFiles.isEmpty()));
        this.myBuildFiles = buildFiles;
        this.myVersion = version2;
        this.myRemoveBuildTools = removeBuildTools;
    }

    @NotNull
    private static String getText(@NotNull String version2, boolean hasBuildFiles) {
        String msg = String.format("Install Build Tools %1$s", version2);
        msg = hasBuildFiles ? msg + ", update version in build file and sync project" : msg + " and sync project";
        return msg;
    }

    @Override
    protected void execute(@NotNull Project project) {
        ArrayList requested = Lists.newArrayList();
        Revision minBuildToolsRev = Revision.parseRevision((String)this.myVersion);
        requested.add(DetailsTypes.getBuildToolsPath((Revision)minBuildToolsRev));
        ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths(project, requested);
        if (dialog2 != null && dialog2.showAndGet()) {
            if (!this.myBuildFiles.isEmpty()) {
                FixBuildToolsProcessor processor = new FixBuildToolsProcessor(project, this.myBuildFiles, this.myVersion, true, this.myRemoveBuildTools);
                processor.setPreviewUsages(true);
                processor.run();
            } else {
                GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_QF_BUILD_TOOLS_INSTALLED);
            }
        }
    }
}

