/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.repository.Revision;
import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallCMakeHyperlink
extends NotificationHyperlink {
    @Nullable
    private Revision myCmakeVersion;

    public InstallCMakeHyperlink() {
        super("install.cmake", "Install CMake");
        this.myCmakeVersion = null;
    }

    public InstallCMakeHyperlink(@NotNull Revision cmakeVersion) {
        super("install.cmake", "Install CMake " + cmakeVersion.toString());
        this.myCmakeVersion = cmakeVersion;
    }

    @Nullable
    public Revision getCmakeVersion() {
        return this.myCmakeVersion;
    }

    @Override
    protected void execute(@NotNull Project project) {
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        StudioLoggerProgressIndicator progressIndicator = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager sdkManager = sdkHandler.getSdkManager((ProgressIndicator)progressIndicator);
        StudioProgressRunner progressRunner = new StudioProgressRunner(false, false, "Loading Remote SDK", project);
        RepoManager.RepoLoadedCallback onComplete = packages -> ApplicationManager.getApplication().invokeLater(() -> {
            Collection cmakePackages = packages.getRemotePackagesForPrefix("cmake");
            RemotePackage cmakePackage = this.myCmakeVersion == null ? (cmakePackages.size() == 1 ? (RemotePackage)ContainerUtil.getFirstItem((Collection)cmakePackages) : sdkHandler.getLatestRemotePackageForPrefix("cmake", false, (ProgressIndicator)progressIndicator)) : (RemotePackage)cmakePackages.stream().filter(remotePackage -> remotePackage.getVersion().equals((Object)this.myCmakeVersion)).findFirst().orElse(null);
            if (cmakePackage != null) {
                ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths(project, (Collection<String>)ImmutableList.of((Object)cmakePackage.getPath()), true);
                if (dialog2 != null && dialog2.showAndGet()) {
                    GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_QF_CMAKE_INSTALLED);
                }
                return;
            }
            InstallCMakeHyperlink.notifyCMakePackageNotFound(project, this.myCmakeVersion);
        }, ModalityState.any());
        Runnable onError = () -> ApplicationManager.getApplication().invokeLater(() -> InstallCMakeHyperlink.notifyCMakePackageInstallError(project), ModalityState.any());
        sdkManager.load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, (List)ImmutableList.of((Object)onComplete), (List)ImmutableList.of((Object)onError), (ProgressRunner)progressRunner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
    }

    private static void notifyCMakePackageNotFound(@NotNull Project project, @Nullable Revision cmakeVersion) {
        if (cmakeVersion == null) {
            Messages.showErrorDialog((Project)project, (String)"Failed to obtain CMake package", (String)"Gradle Sync");
        } else {
            Messages.showErrorDialog((Project)project, (String)("Failed to obtain CMake package version " + cmakeVersion.toString()), (String)"Gradle Sync");
        }
    }

    private static void notifyCMakePackageInstallError(@NotNull Project project) {
        Messages.showErrorDialog((Project)project, (String)"Failed to install CMake package", (String)"Gradle Sync");
    }
}

