/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.repository.Revision;
import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.SelectNdkDialog;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallNdkHyperlink
extends NotificationHyperlink {
    private static final String ERROR_TITLE = "Gradle Sync Error";

    public InstallNdkHyperlink() {
        super("install.ndk", "Install NDK");
    }

    @Override
    protected void execute(@NotNull Project project) {
        File path = InstallNdkHyperlink.getNdkPath(project);
        if (path != null) {
            SelectNdkDialog dialog2 = new SelectNdkDialog(path.getPath(), false, true);
            dialog2.setModal(true);
            if (dialog2.showAndGet() && InstallNdkHyperlink.setNdkPath(project, dialog2.getAndroidNdkPath())) {
                GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_QF_NDK_INSTALLED);
            }
            return;
        }
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        StudioLoggerProgressIndicator progressIndicator = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager sdkManager = sdkHandler.getSdkManager((ProgressIndicator)progressIndicator);
        StudioProgressRunner progressRunner = new StudioProgressRunner(false, false, "Loading Remote SDK", project);
        RepoManager.RepoLoadedCallback onComplete = packages -> ApplicationManager.getApplication().invokeLater(() -> {
            String ndkPath = null;
            Revision ndkRevision = null;
            if (((Boolean)StudioFlags.NDK_SIDE_BY_SIDE_ENABLED.get()).booleanValue()) {
                Collection ndkPackages = packages.getRemotePackagesForPrefix("ndk");
                for (RemotePackage ndkPackage : ndkPackages) {
                    if (ndkRevision != null && ndkRevision.compareTo(ndkPackage.getVersion()) >= 0) continue;
                    ndkRevision = ndkPackage.getVersion();
                    ndkPath = ndkPackage.getPath();
                }
            } else {
                Map remotePackages = packages.getRemotePackages();
                RemotePackage ndkPackage = (RemotePackage)remotePackages.get("ndk-bundle");
                if (ndkPackage != null) {
                    ndkPath = ndkPackage.getPath();
                }
            }
            if (ndkPath != null) {
                ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths(project, (Collection<String>)ImmutableList.of((Object)ndkPath), true);
                if (dialog2 != null && dialog2.showAndGet()) {
                    GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_QF_NDK_INSTALLED);
                }
                return;
            }
            InstallNdkHyperlink.notifyNdkPackageNotFound(project);
        }, ModalityState.any());
        Runnable onError = () -> ApplicationManager.getApplication().invokeLater(() -> InstallNdkHyperlink.notifyNdkPackageNotFound(project), ModalityState.any());
        sdkManager.load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, (List)ImmutableList.of((Object)onComplete), (List)ImmutableList.of((Object)onError), (ProgressRunner)progressRunner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
    }

    @Nullable
    private static File getNdkPath(@NotNull Project project) {
        try {
            return new LocalProperties(project).getAndroidNdkPath();
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file of Project '%1$s'", project.getName());
            Logger.getInstance(InstallNdkHyperlink.class).info(msg, (Throwable)e);
            return null;
        }
    }

    private static boolean setNdkPath(@NotNull Project project, @Nullable String ndkPath) {
        LocalProperties localProperties;
        try {
            localProperties = new LocalProperties(project);
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file of Project '%1$s':\n%2$s", project.getName(), e.getMessage());
            Messages.showErrorDialog((Project)project, (String)msg, (String)ERROR_TITLE);
            return false;
        }
        try {
            localProperties.setAndroidNdkPath(ndkPath == null ? null : new File(ndkPath));
            localProperties.save();
        }
        catch (IOException e) {
            String msg = String.format("Unable to save local.properties file of Project '%1$s: %2$s", localProperties.getPropertiesFilePath().getPath(), e.getMessage());
            Messages.showErrorDialog((Project)project, (String)msg, (String)ERROR_TITLE);
            return false;
        }
        return true;
    }

    private static void notifyNdkPackageNotFound(@NotNull Project project) {
        Messages.showErrorDialog((Project)project, (String)"Failed to obtain NDK package", (String)ERROR_TITLE);
    }
}

