/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class InstallPlatformHyperlink
extends NotificationHyperlink {
    @NotNull
    private final AndroidVersion[] myAndroidVersions;

    public InstallPlatformHyperlink(@NotNull Collection<AndroidVersion> androidVersions) {
        this(androidVersions.toArray(new AndroidVersion[0]));
    }

    public InstallPlatformHyperlink(AndroidVersion ... androidVersions) {
        super("install.android.platform", "Install missing platform(s) and sync project");
        this.myAndroidVersions = androidVersions;
    }

    @Override
    protected void execute(@NotNull Project project) {
        ArrayList requested = Lists.newArrayList();
        for (AndroidVersion version2 : this.myAndroidVersions) {
            requested.add(DetailsTypes.getPlatformPath((AndroidVersion)version2));
        }
        ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths(project, requested);
        if (dialog2 != null && dialog2.showAndGet()) {
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_QF_PLATFORM_INSTALLED);
        }
    }
}

