/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UseJavaHomeAsJdkHyperlink
extends NotificationHyperlink {
    @NotNull
    private String myJavaHome;

    @Nullable
    public static UseJavaHomeAsJdkHyperlink create() {
        String javaHome = IdeSdks.getJdkFromJavaHome();
        if (!StringUtil.isEmpty((String)javaHome)) {
            return new UseJavaHomeAsJdkHyperlink(javaHome);
        }
        return null;
    }

    private UseJavaHomeAsJdkHyperlink(@NotNull String javaHome) {
        super("useJavaHomeAsJdk", "Set Android Studio to use the same JDK as Gradle and sync project");
        this.myJavaHome = javaHome;
    }

    @Override
    protected void execute(@NotNull Project project) {
        ApplicationManager.getApplication().runWriteAction(() -> IdeSdks.getInstance().setJdkPath(new File(this.myJavaHome)));
        GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_QF_JDK_CHANGED_TO_CURRENT);
    }
}

