/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.Variant;
import com.android.builder.model.level2.GlobalLibraryMap;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeNativeAndroidProject;
import com.android.ide.common.gradle.model.IdeNativeAndroidProjectImpl;
import com.android.ide.common.gradle.model.IdeNativeVariantAbi;
import com.android.ide.common.gradle.model.level2.IdeDependenciesFactory;
import com.android.ide.common.repository.GradleVersion;
import com.android.repository.Revision;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.IdeaJavaModuleModelFactory;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.SimulatedSyncErrors;
import com.android.tools.idea.gradle.project.sync.common.CommandLineArgs;
import com.android.tools.idea.gradle.project.sync.common.VariantSelector;
import com.android.tools.idea.gradle.project.sync.errors.GradleDistributionInstallErrorHandler;
import com.android.tools.idea.gradle.project.sync.idea.GradleModelVersionCheck;
import com.android.tools.idea.gradle.project.sync.idea.ProjectFinder;
import com.android.tools.idea.gradle.project.sync.idea.ProjectImportErrorHandler;
import com.android.tools.idea.gradle.project.sync.idea.data.model.ImportedModule;
import com.android.tools.idea.gradle.project.sync.idea.data.model.ProjectCleanupModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.svs.AndroidExtraModelProvider;
import com.android.tools.idea.gradle.project.sync.idea.svs.VariantGroup;
import com.android.tools.idea.gradle.project.sync.ng.NewGradleSync;
import com.android.tools.idea.gradle.project.sync.ng.SelectedVariantCollector;
import com.android.tools.idea.gradle.project.sync.ng.SelectedVariants;
import com.android.tools.idea.gradle.project.sync.ng.SyncActionOptions;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipException;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleScript;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kapt.idea.KaptGradleModel;
import org.jetbrains.kotlin.kapt.idea.KaptSourceSetModel;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;
import org.jetbrains.plugins.gradle.model.ProjectImportExtraModelProvider;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class AndroidGradleProjectResolver
extends AbstractProjectResolverExtension {
    private static final Key<Boolean> IS_ANDROID_PROJECT_KEY = Key.create((String)"IS_ANDROID_PROJECT_KEY");
    @NotNull
    private final CommandLineArgs myCommandLineArgs;
    @NotNull
    private final ProjectImportErrorHandler myErrorHandler;
    @NotNull
    private final ProjectFinder myProjectFinder;
    @NotNull
    private final VariantSelector myVariantSelector;
    @NotNull
    private final IdeNativeAndroidProject.Factory myNativeAndroidProjectFactory;
    @NotNull
    private final IdeaJavaModuleModelFactory myIdeaJavaModuleModelFactory;
    @NotNull
    private final IdeDependenciesFactory myDependenciesFactory;

    public AndroidGradleProjectResolver() {
        this(new CommandLineArgs(false), new ProjectImportErrorHandler(), new ProjectFinder(), new VariantSelector(), (IdeNativeAndroidProject.Factory)new IdeNativeAndroidProjectImpl.FactoryImpl(), new IdeaJavaModuleModelFactory(), new IdeDependenciesFactory());
    }

    @VisibleForTesting
    AndroidGradleProjectResolver(@NotNull CommandLineArgs commandLineArgs, @NotNull ProjectImportErrorHandler errorHandler, @NotNull ProjectFinder projectFinder, @NotNull VariantSelector variantSelector, @NotNull IdeNativeAndroidProject.Factory nativeAndroidProjectFactory, @NotNull IdeaJavaModuleModelFactory ideaJavaModuleModelFactory, @NotNull IdeDependenciesFactory dependenciesFactory) {
        this.myCommandLineArgs = commandLineArgs;
        this.myErrorHandler = errorHandler;
        this.myProjectFinder = projectFinder;
        this.myVariantSelector = variantSelector;
        this.myNativeAndroidProjectFactory = nativeAndroidProjectFactory;
        this.myIdeaJavaModuleModelFactory = ideaJavaModuleModelFactory;
        this.myDependenciesFactory = dependenciesFactory;
    }

    @NotNull
    public DataNode<ModuleData> createModule(@NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        AndroidProject androidProject = (AndroidProject)this.resolverCtx.getExtraProject(gradleModule, AndroidProject.class);
        if (androidProject != null && !GradleModelVersionCheck.isSupportedVersion(androidProject)) {
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
            event.setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE_DETAILS).setGradleSyncFailure(AndroidStudioEvent.GradleSyncFailure.UNSUPPORTED_ANDROID_MODEL_VERSION).setGradleVersion(androidProject.getModelVersion());
            UsageTrackerUtils.withProjectId(event, this.myProjectFinder.findProject(this.resolverCtx));
            UsageTracker.log((AndroidStudioEvent.Builder)event);
            String msg = AndroidGradleProjectResolver.getUnsupportedModelVersionErrorMsg(GradleModelVersionCheck.getModelVersion(androidProject));
            throw new IllegalStateException(msg);
        }
        if (this.isAndroidGradleProject()) {
            return this.doCreateModule(gradleModule, projectDataNode);
        }
        return this.nextResolver.createModule(gradleModule, projectDataNode);
    }

    @NotNull
    private DataNode<ModuleData> doCreateModule(@NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        String moduleName = gradleModule.getName();
        if (moduleName == null) {
            throw new IllegalStateException("Module with undefined name detected: " + gradleModule);
        }
        String projectPath = ((ProjectData)projectDataNode.getData()).getLinkedExternalProjectPath();
        String moduleConfigPath = GradleProjectResolverUtil.getModuleConfigPath((ProjectResolverContext)this.resolverCtx, (IdeaModule)gradleModule, (String)projectPath);
        String gradlePath = gradleModule.getGradleProject().getPath();
        String moduleId = StringUtil.isEmpty((String)gradlePath) || ":".equals(gradlePath) ? moduleName : gradlePath;
        ProjectSystemId owner = GradleConstants.SYSTEM_ID;
        String typeId = StdModuleTypes.JAVA.getId();
        ModuleData moduleData = new ModuleData(moduleId, owner, typeId, moduleName, moduleConfigPath, moduleConfigPath);
        ExternalProject externalProject = (ExternalProject)this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (externalProject != null) {
            moduleData.setDescription(externalProject.getDescription());
        }
        return projectDataNode.createChild(ProjectKeys.MODULE, (Object)moduleData);
    }

    public void populateModuleContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        File gradleSettingsFile;
        NativeAndroidProject nativeAndroidProject;
        if (!this.isAndroidGradleProject()) {
            this.nextResolver.populateModuleContentRoots(gradleModule, ideModule);
            return;
        }
        ImportedModule importedModule = new ImportedModule(gradleModule);
        ideModule.createChild(AndroidProjectKeys.IMPORTED_MODULE, (Object)importedModule);
        File moduleRootDirPath = FilePaths.toSystemDependentPath((String)((ModuleData)ideModule.getData()).getLinkedExternalProjectPath());
        AndroidProject androidProject = (AndroidProject)this.resolverCtx.getExtraProject(gradleModule, AndroidProject.class);
        boolean androidProjectWithoutVariants = false;
        ArrayList<SyncIssue> syncIssues = new ArrayList();
        String moduleName = gradleModule.getName();
        VariantGroup variantGroup = (VariantGroup)this.resolverCtx.getExtraProject(gradleModule, VariantGroup.class);
        if (androidProject != null) {
            List<Variant> variants;
            Variant selectedVariant = this.myVariantSelector.findVariantToSelect(androidProject);
            if (selectedVariant == null && variantGroup != null && !(variants = variantGroup.getVariants()).isEmpty()) {
                selectedVariant = variants.get(0);
            }
            if (selectedVariant == null) {
                androidProjectWithoutVariants = true;
                syncIssues = androidProject.getSyncIssues();
            } else {
                AndroidModuleModel model2 = new AndroidModuleModel(moduleName, moduleRootDirPath, androidProject, selectedVariant.getName(), this.myDependenciesFactory, variantGroup == null ? null : variantGroup.getVariants());
                this.populateKaptKotlinGeneratedSourceDir(gradleModule, model2);
                ideModule.createChild(AndroidProjectKeys.ANDROID_MODEL, (Object)model2);
            }
        }
        if ((nativeAndroidProject = (NativeAndroidProject)this.resolverCtx.getExtraProject(gradleModule, NativeAndroidProject.class)) != null) {
            IdeNativeAndroidProject copy = this.myNativeAndroidProjectFactory.create(nativeAndroidProject);
            ArrayList<IdeNativeVariantAbi> ideNativeVariantAbis = new ArrayList<IdeNativeVariantAbi>();
            if (variantGroup != null) {
                ideNativeVariantAbis.addAll(variantGroup.getNativeVariants().stream().map(IdeNativeVariantAbi::new).collect(Collectors.toList()));
            }
            NdkModuleModel ndkModuleModel = new NdkModuleModel(moduleName, moduleRootDirPath, copy, ideNativeVariantAbis);
            ideModule.createChild(AndroidProjectKeys.NDK_MODEL, (Object)ndkModuleModel);
        }
        if ((gradleSettingsFile = new File(moduleRootDirPath, "settings.gradle")).isFile() && androidProject == null && nativeAndroidProject == null && !this.hasArtifacts(gradleModule)) {
            this.createJavaProject(gradleModule, ideModule, syncIssues, false);
            return;
        }
        BuildScriptClasspathModel buildScriptModel = (BuildScriptClasspathModel)this.resolverCtx.getExtraProject(BuildScriptClasspathModel.class);
        String gradleVersion2 = buildScriptModel != null ? buildScriptModel.getGradleVersion() : null;
        GradleProject gradleProject = gradleModule.getGradleProject();
        GradleScript buildScript = null;
        try {
            buildScript = gradleProject.getBuildScript();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        File buildFilePath = buildScript != null ? buildScript.getSourceFile() : null;
        String agpVersion = androidProject != null ? androidProject.getModelVersion() : null;
        GradleModuleModel gradleModuleModel = new GradleModuleModel(moduleName, gradleProject, Collections.emptyList(), buildFilePath, gradleVersion2, agpVersion);
        ideModule.createChild(AndroidProjectKeys.GRADLE_MODULE_MODEL, (Object)gradleModuleModel);
        if (nativeAndroidProject == null && (androidProject == null || androidProjectWithoutVariants)) {
            this.createJavaProject(gradleModule, ideModule, syncIssues, androidProjectWithoutVariants);
            if ("buildSrc".equals(gradleModule.getGradleProject().getName())) {
                this.nextResolver.populateModuleContentRoots(gradleModule, ideModule);
            }
        }
    }

    private boolean hasArtifacts(@NotNull IdeaModule gradleModule) {
        ModuleExtendedModel javaModel = (ModuleExtendedModel)this.resolverCtx.getExtraProject(gradleModule, ModuleExtendedModel.class);
        return javaModel != null && !javaModel.getArtifacts().isEmpty();
    }

    private void createJavaProject(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull Collection<SyncIssue> syncIssues, boolean androidProjectWithoutVariants) {
        ModuleExtendedModel model2 = (ModuleExtendedModel)this.resolverCtx.getExtraProject(gradleModule, ModuleExtendedModel.class);
        JavaModuleModel javaModuleModel = this.myIdeaJavaModuleModelFactory.create(gradleModule, model2, syncIssues, androidProjectWithoutVariants);
        ideModule.createChild(AndroidProjectKeys.JAVA_MODULE_MODEL, (Object)javaModuleModel);
    }

    public void populateModuleCompileOutputSettings(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        if (!this.isAndroidGradleProject()) {
            this.nextResolver.populateModuleCompileOutputSettings(gradleModule, ideModule);
        }
    }

    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) {
        if (!this.isAndroidGradleProject()) {
            this.nextResolver.populateModuleDependencies(gradleModule, ideModule, ideProject);
        }
    }

    private boolean isAndroidGradleProject() {
        Boolean isAndroidGradleProject = (Boolean)this.resolverCtx.getUserData(IS_ANDROID_PROJECT_KEY);
        if (isAndroidGradleProject != null) {
            return isAndroidGradleProject;
        }
        isAndroidGradleProject = this.resolverCtx.hasModulesWithModel(AndroidProject.class) || this.resolverCtx.hasModulesWithModel(NativeAndroidProject.class);
        return (Boolean)this.resolverCtx.putUserDataIfAbsent(IS_ANDROID_PROJECT_KEY, (Object)isAndroidGradleProject);
    }

    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> projectDataNode) {
        this.populateModuleBuildDirs(gradleProject);
        this.populateGlobalLibraryMap(gradleProject);
        if (this.isAndroidGradleProject()) {
            projectDataNode.createChild(AndroidProjectKeys.PROJECT_CLEANUP_MODEL, (Object)ProjectCleanupModel.getInstance());
        }
        super.populateProjectExtraModels(gradleProject, projectDataNode);
    }

    private void populateKaptKotlinGeneratedSourceDir(@NotNull IdeaModule gradleModule, @NotNull AndroidModuleModel androidModuleModel) {
        KaptGradleModel kaptGradleModel = (KaptGradleModel)this.resolverCtx.getExtraProject(gradleModule, KaptGradleModel.class);
        if (kaptGradleModel == null || !kaptGradleModel.isEnabled()) {
            return;
        }
        for (KaptSourceSetModel sourceSetModel : kaptGradleModel.getSourceSets()) {
            AndroidArtifact mainArtifact;
            Variant variant = androidModuleModel.findVariantByName(sourceSetModel.getSourceSetName());
            File kotlinGenSourceDir = sourceSetModel.getGeneratedKotlinSourcesDirFile();
            if (variant == null || kotlinGenSourceDir == null || !((mainArtifact = variant.getMainArtifact()) instanceof IdeBaseArtifact)) continue;
            ((IdeBaseArtifact)mainArtifact).addGeneratedSourceFolder(kotlinGenSourceDir);
        }
    }

    private void populateModuleBuildDirs(@NotNull IdeaProject rootIdeaProject) {
        for (IdeaModule ideaModule : rootIdeaProject.getChildren()) {
            GradleProject gradleProject = ideaModule.getGradleProject();
            if (gradleProject == null) continue;
            String rootBuildId = gradleProject.getProjectIdentifier().getBuildIdentifier().getRootDir().getPath();
            this.myDependenciesFactory.setRootBuildId(rootBuildId);
            break;
        }
        ArrayList<IdeaProject> ideaProjects = new ArrayList<IdeaProject>();
        ideaProjects.add(rootIdeaProject);
        ideaProjects.addAll(this.resolverCtx.getModels().getIncludedBuilds());
        for (IdeaProject ideaProject : ideaProjects) {
            for (IdeaModule ideaModule : ideaProject.getChildren()) {
                GradleProject gradleProject = ideaModule.getGradleProject();
                if (gradleProject == null) continue;
                try {
                    String buildId2 = gradleProject.getProjectIdentifier().getBuildIdentifier().getRootDir().getPath();
                    this.myDependenciesFactory.findAndAddBuildFolderPath(buildId2, gradleProject.getPath(), gradleProject.getBuildDirectory());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }
    }

    private void populateGlobalLibraryMap(@NotNull IdeaProject rootIdeaProject) {
        ArrayList<GlobalLibraryMap> globalLibraryMaps = new ArrayList<GlobalLibraryMap>();
        ArrayList<IdeaProject> ideaProjects = new ArrayList<IdeaProject>();
        ideaProjects.add(rootIdeaProject);
        ideaProjects.addAll(this.resolverCtx.getModels().getIncludedBuilds());
        for (IdeaProject ideaProject : ideaProjects) {
            GlobalLibraryMap mapOfCurrentBuild = null;
            for (IdeaModule ideaModule : ideaProject.getChildren()) {
                GlobalLibraryMap moduleMap = (GlobalLibraryMap)this.resolverCtx.getExtraProject(ideaModule, GlobalLibraryMap.class);
                if (mapOfCurrentBuild != null && (moduleMap == null || moduleMap.getLibraries().size() <= mapOfCurrentBuild.getLibraries().size())) continue;
                mapOfCurrentBuild = moduleMap;
            }
            if (mapOfCurrentBuild == null) continue;
            globalLibraryMaps.add(mapOfCurrentBuild);
        }
        this.myDependenciesFactory.setUpGlobalLibraryMap(globalLibraryMaps);
    }

    @NotNull
    public Set<Class> getExtraProjectModelClasses() {
        LinkedHashSet<Class> modelClasses = new LinkedHashSet<Class>();
        modelClasses.add(AndroidProject.class);
        modelClasses.add(NativeAndroidProject.class);
        modelClasses.add(GlobalLibraryMap.class);
        return modelClasses;
    }

    @NotNull
    public ProjectImportExtraModelProvider getExtraModelProvider() {
        return super.getExtraModelProvider();
    }

    public void preImportCheck() {
        SimulatedSyncErrors.simulateRegisteredSyncError();
    }

    @NotNull
    public List<Pair<String, String>> getExtraJvmArgs() {
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID)) {
            File androidHomePath;
            LocalProperties localProperties;
            ArrayList<Pair<String, String>> args = new ArrayList<Pair<String, String>>();
            if (!IdeInfo.getInstance().isAndroidStudio() && (localProperties = this.getLocalProperties()).getAndroidSdkPath() == null && (androidHomePath = IdeSdks.getInstance().getAndroidSdkPath()) != null) {
                args.add((Pair<String, String>)Pair.create((Object)"android.home", (Object)androidHomePath.getPath()));
            }
            return args;
        }
        return Collections.emptyList();
    }

    @NotNull
    private LocalProperties getLocalProperties() {
        File projectDir = FilePaths.toSystemDependentPath((String)this.resolverCtx.getProjectPath());
        try {
            return new LocalProperties(projectDir);
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file in project '%1$s'", projectDir.getPath());
            throw new ExternalSystemException(msg, (Throwable)e, new String[0]);
        }
    }

    @NotNull
    public List<String> getExtraCommandLineArgs() {
        Project project = this.myProjectFinder.findProject(this.resolverCtx);
        return this.myCommandLineArgs.get(project);
    }

    @NotNull
    public ExternalSystemException getUserFriendlyError(@NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        String msg = error.getMessage();
        if (msg != null && !msg.contains("The project is using an unsupported version of the Android Gradle plug-in")) {
            Throwable rootCause = ExceptionUtil.getRootCause((Throwable)error);
            if (rootCause instanceof ClassNotFoundException) {
                msg = rootCause.getMessage();
                if (AndroidGradleProjectResolver.isUsingUnsupportedGradleVersion(msg)) {
                    AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder();
                    event.setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_SYNC_FAILURE_DETAILS).setGradleSyncFailure(AndroidStudioEvent.GradleSyncFailure.UNSUPPORTED_GRADLE_VERSION);
                    UsageTrackerUtils.withProjectId(event, this.myProjectFinder.findProject(this.resolverCtx));
                    UsageTracker.log((AndroidStudioEvent.Builder)event);
                    return new ExternalSystemException("The project is using an unsupported version of Gradle.");
                }
            } else if (rootCause instanceof ZipException && GradleDistributionInstallErrorHandler.COULD_NOT_INSTALL_GRADLE_DISTRIBUTION_PATTERN.matcher(msg).matches()) {
                return new ExternalSystemException(msg);
            }
        }
        ExternalSystemException userFriendlyError = this.myErrorHandler.getUserFriendlyError(error, projectPath, buildFilePath);
        assert (userFriendlyError != null);
        return userFriendlyError;
    }

    private static boolean isUsingUnsupportedGradleVersion(@Nullable String errorMessage) {
        return "org.gradle.api.artifacts.result.ResolvedComponentResult".equals(errorMessage) || "org.gradle.api.artifacts.result.ResolvedModuleVersionResult".equals(errorMessage);
    }

    @NotNull
    private static String getUnsupportedModelVersionErrorMsg(@Nullable GradleVersion modelVersion) {
        StringBuilder builder = new StringBuilder();
        builder.append("The project is using an unsupported version of the Android Gradle plug-in");
        String recommendedVersion = String.format("The recommended version is %1$s.", LatestKnownPluginVersionProvider.INSTANCE.get());
        if (modelVersion != null) {
            builder.append(String.format(" (%1$s).", modelVersion.toString())).append(" ").append(recommendedVersion);
            if (modelVersion.getMajor() == 0 && modelVersion.getMinor() <= 8) {
                builder.append("\n\nStarting with version 0.9.0 incompatible changes were introduced in the build language.\n").append("Please read the migration guide").append(" to learn how to update your project.");
            }
        } else {
            builder.append(". ").append(recommendedVersion);
        }
        return builder.toString();
    }

    @NotNull
    private AndroidExtraModelProvider configureAndGetExtraModelProvider() {
        Project project = this.myProjectFinder.findProject(this.resolverCtx);
        SelectedVariants selectedVariants2 = null;
        boolean isSingleVariantSync = false;
        boolean shouldGenerateSources = false;
        if (project != null) {
            isSingleVariantSync = NewGradleSync.isSingleVariantSync(project);
            shouldGenerateSources = NewGradleSync.isCompoundSync(project);
            if (isSingleVariantSync) {
                SelectedVariantCollector variantCollector = new SelectedVariantCollector(project);
                selectedVariants2 = variantCollector.collectSelectedVariants();
            }
        }
        SyncActionOptions options = new SyncActionOptions();
        options.setSingleVariantSyncEnabled(isSingleVariantSync);
        options.setShouldGenerateSources(shouldGenerateSources);
        options.setSelectedVariants(selectedVariants2);
        return new AndroidExtraModelProvider(options);
    }

    public void enhanceRemoteProcessing(@NotNull SimpleJavaParameters parameters2) {
        PathsList classPath = parameters2.getClassPath();
        classPath.add(PathUtil.getJarPathForClass(((Object)((Object)this)).getClass()));
        classPath.add(PathUtil.getJarPathForClass(Revision.class));
        classPath.add(PathUtil.getJarPathForClass(AndroidGradleSettings.class));
        classPath.add(PathUtil.getJarPathForClass(AndroidProject.class));
    }
}

