/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.ProjectBuildFileChecksums;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.GradleSync;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.PsdModuleModels;
import com.android.tools.idea.gradle.project.sync.idea.ProjectFinder;
import com.android.tools.idea.gradle.project.sync.idea.ProjectSetUpTask;
import com.android.tools.idea.gradle.project.sync.idea.data.DataNodeCaches;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.ng.NewGradleSync;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.GradleProjectOpenProcessor;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class IdeaGradleSync
implements GradleSync {
    private static final boolean SYNC_WITH_CACHED_MODEL_ONLY = SystemProperties.getBooleanProperty((String)"studio.sync.with.cached.model.only", (boolean)false);
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleProjectInfo myProjectInfo;

    public IdeaGradleSync(@NotNull Project project) {
        this(project, GradleProjectInfo.getInstance(project));
    }

    private IdeaGradleSync(@NotNull Project project, @NotNull GradleProjectInfo projectInfo) {
        this.myProject = project;
        this.myProjectInfo = projectInfo;
    }

    @Override
    public void sync(@NotNull GradleSyncInvoker.Request request, @Nullable GradleSyncListener listener2) {
        String externalProjectPath;
        DataNodeCaches dataNodeCaches;
        DataNode<ProjectData> cache2;
        ProjectBuildFileChecksums buildFileChecksums;
        if (this.myProjectInfo.isNewProject()) {
            ProjectFinder.registerAsNewProject(this.myProject);
        }
        if ((SYNC_WITH_CACHED_MODEL_ONLY || request.useCachedGradleModels) && (buildFileChecksums = ProjectBuildFileChecksums.findFor(this.myProject)) != null && buildFileChecksums.canUseCachedData() && (cache2 = (dataNodeCaches = DataNodeCaches.getInstance(this.myProject)).getCachedProjectData()) != null && !dataNodeCaches.isCacheMissingModels(cache2) && !NewGradleSync.areCachedFilesMissing(this.myProject)) {
            PostSyncProjectSetup.Request setupRequest = new PostSyncProjectSetup.Request();
            setupRequest.usingCachedGradleModels = true;
            setupRequest.generateSourcesAfterSync = true;
            setupRequest.lastSyncTimestamp = buildFileChecksums.getLastGradleSyncTimestamp();
            IdeaGradleSync.setSkipAndroidPluginUpgrade(request, setupRequest);
            ExternalSystemTaskId taskId = PostSyncProjectSetup.createProjectSetupFromCacheTaskWithStartMessage(this.myProject);
            ProjectSetUpTask setUpTask = new ProjectSetUpTask(this.myProject, setupRequest, listener2, true);
            setUpTask.onSuccess(taskId, cache2);
            return;
        }
        PostSyncProjectSetup.Request setupRequest = new PostSyncProjectSetup.Request();
        setupRequest.generateSourcesAfterSync = request.generateSourcesOnSuccess;
        setupRequest.cleanProjectAfterSync = request.cleanProject;
        setupRequest.usingCachedGradleModels = false;
        IdeaGradleSync.setSkipAndroidPluginUpgrade(request, setupRequest);
        LinkedHashSet<String> androidProjectCandidatesPaths = new LinkedHashSet<String>();
        if (this.myProjectInfo.isImportedProject()) {
            IdeaGradleSync.createGradleProjectSettingsIfNotExist(this.myProject);
            Collection projectsSettings = GradleSettings.getInstance((Project)this.myProject).getLinkedProjectsSettings();
            if (projectsSettings.size() == 1) {
                androidProjectCandidatesPaths.add(((GradleProjectSettings)projectsSettings.iterator().next()).getExternalProjectPath());
            }
        } else {
            for (Module module : ProjectFacetManager.getInstance((Project)this.myProject).getModulesWithFacet(GradleFacet.getFacetTypeId())) {
                String projectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
                if (projectPath == null) continue;
                androidProjectCandidatesPaths.add(projectPath);
            }
        }
        if (androidProjectCandidatesPaths.isEmpty() && (new File(externalProjectPath = ExternalSystemApiUtil.toCanonicalPath((String)Projects.getBaseDirPath((Project)this.myProject).getPath()), "build.gradle").isFile() || new File(externalProjectPath, "settings.gradle").isFile())) {
            androidProjectCandidatesPaths.add(externalProjectPath);
        }
        if (androidProjectCandidatesPaths.isEmpty()) {
            if (listener2 != null) {
                listener2.syncSkipped(this.myProject);
            }
            GradleSyncState.getInstance(this.myProject).syncSkipped(System.currentTimeMillis());
            return;
        }
        for (String rootPath : androidProjectCandidatesPaths) {
            ProjectSetUpTask setUpTask = new ProjectSetUpTask(this.myProject, setupRequest, listener2, false);
            ProgressExecutionMode executionMode = request.getProgressExecutionMode();
            ExternalSystemUtil.refreshProject((Project)this.myProject, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (String)rootPath, (ExternalProjectRefreshCallback)setUpTask, (boolean)false, (ProgressExecutionMode)executionMode, (boolean)true);
        }
    }

    public static void createGradleProjectSettingsIfNotExist(@NotNull Project project) {
        GradleSettings gradleSettings = GradleSettings.getInstance((Project)project);
        Collection projectsSettings = gradleSettings.getLinkedProjectsSettings();
        if (projectsSettings.isEmpty()) {
            GradleProjectOpenProcessor projectOpenProcessor = (GradleProjectOpenProcessor)ProjectOpenProcessor.EXTENSION_POINT_NAME.findExtensionOrFail(GradleProjectOpenProcessor.class);
            if (project.getBasePath() != null && projectOpenProcessor.canOpenProject(project.getBaseDir())) {
                GradleProjectSettings projectSettings = new GradleProjectSettings();
                String externalProjectPath = ExternalSystemApiUtil.toCanonicalPath((String)project.getBasePath());
                projectSettings.setExternalProjectPath(externalProjectPath);
                gradleSettings.setLinkedProjectsSettings(Collections.singletonList(projectSettings));
            }
        }
    }

    private static void setSkipAndroidPluginUpgrade(@NotNull GradleSyncInvoker.Request syncRequest, @NotNull PostSyncProjectSetup.Request setupRequest) {
        if (ApplicationManager.getApplication().isUnitTestMode() && syncRequest.skipAndroidPluginUpgrade) {
            setupRequest.skipAndroidPluginUpgrade = true;
        }
    }

    @Override
    @NotNull
    public List<GradleModuleModels> fetchGradleModels(@NotNull ProgressIndicator indicator) {
        GradleExecutionSettings settings = GradleUtil.getGradleExecutionSettings(this.myProject);
        ExternalSystemTaskId id = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)this.myProject);
        String projectPath = this.myProject.getBasePath();
        assert (projectPath != null);
        GradleProjectResolver projectResolver = new GradleProjectResolver();
        DataNode projectDataNode = projectResolver.resolveProjectInfo(id, projectPath, false, settings, ExternalSystemTaskNotificationListenerAdapter.NULL_OBJECT);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (projectDataNode != null) {
            Collection moduleNodes = ExternalSystemApiUtil.findAll((DataNode)projectDataNode, (Key)ProjectKeys.MODULE);
            for (DataNode moduleNode : moduleNodes) {
                DataNode gradleModelNode = ExternalSystemApiUtil.find((DataNode)moduleNode, AndroidProjectKeys.GRADLE_MODULE_MODEL);
                if (gradleModelNode == null) continue;
                PsdModuleModels moduleModules = new PsdModuleModels(((ModuleData)moduleNode.getData()).getExternalName());
                moduleModules.addModel(GradleModuleModel.class, gradleModelNode.getData());
                DataNode androidModelNode = ExternalSystemApiUtil.find((DataNode)moduleNode, AndroidProjectKeys.ANDROID_MODEL);
                if (androidModelNode != null) {
                    moduleModules.addModel(AndroidModuleModel.class, androidModelNode.getData());
                    DataNode ndkModelNode = ExternalSystemApiUtil.find((DataNode)moduleNode, AndroidProjectKeys.NDK_MODEL);
                    if (ndkModelNode != null) {
                        moduleModules.addModel(NdkModuleModel.class, ndkModelNode.getData());
                    }
                    builder.add((Object)moduleModules);
                    continue;
                }
                DataNode javaModelNode = ExternalSystemApiUtil.find((DataNode)moduleNode, AndroidProjectKeys.JAVA_MODULE_MODEL);
                if (javaModelNode == null) continue;
                moduleModules.addModel(JavaModuleModel.class, javaModelNode.getData());
                builder.add((Object)moduleModules);
            }
        }
        return builder.build();
    }
}

