/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaSyncPopulateProjectTask {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PostSyncProjectSetup myProjectSetup;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final ProjectDataManager myDataManager;

    public IdeaSyncPopulateProjectTask(@NotNull Project project) {
        this(project, PostSyncProjectSetup.getInstance(project), GradleSyncState.getInstance(project), ProjectDataManager.getInstance());
    }

    @VisibleForTesting
    IdeaSyncPopulateProjectTask(@NotNull Project project, @NotNull PostSyncProjectSetup projectSetup, @NotNull GradleSyncState syncState, @NotNull ProjectDataManager dataManager) {
        this.myProject = project;
        this.myProjectSetup = projectSetup;
        this.mySyncState = syncState;
        this.myDataManager = dataManager;
    }

    public void populateProject(@NotNull DataNode<ProjectData> projectInfo, @NotNull ExternalSystemTaskId taskId) {
        this.populateProject(projectInfo, taskId, null, null);
    }

    public void populateProject(@NotNull DataNode<ProjectData> projectInfo, @NotNull ExternalSystemTaskId taskId, @Nullable PostSyncProjectSetup.Request setupRequest, @Nullable Runnable syncFinishedCallback) {
        this.doPopulateProject(projectInfo, taskId, setupRequest, syncFinishedCallback);
    }

    private void doPopulateProject(final @NotNull DataNode<ProjectData> projectInfo, final @NotNull ExternalSystemTaskId taskId, final @Nullable PostSyncProjectSetup.Request setupRequest, final @Nullable Runnable syncFinishedCallback) {
        UIUtil.invokeAndWaitIfNeeded(() -> GradleSyncMessages.getInstance(this.myProject).removeProjectMessages());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.populate(projectInfo, taskId, (ProgressIndicator)new EmptyProgressIndicator(), setupRequest, syncFinishedCallback);
            return;
        }
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, "Project Setup", false){

            public void run(@NotNull ProgressIndicator indicator) {
                IdeaSyncPopulateProjectTask.this.populate((DataNode<ProjectData>)projectInfo, taskId, indicator, setupRequest, syncFinishedCallback);
            }
        };
        task.queue();
    }

    private void populate(@NotNull DataNode<ProjectData> projectInfo, @NotNull ExternalSystemTaskId taskId, @NotNull ProgressIndicator indicator, @Nullable PostSyncProjectSetup.Request setupRequest, @Nullable Runnable syncFinishedCallback) {
        this.doPopulateProject(projectInfo, this.myProject, setupRequest);
        if (syncFinishedCallback != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                syncFinishedCallback.run();
            } else {
                TransactionGuard.getInstance().submitTransactionLater((Disposable)this.myProject, syncFinishedCallback);
            }
        }
        if (setupRequest != null) {
            PostSyncProjectSetup.getInstance(this.myProject).setUpProject(setupRequest, indicator, taskId);
        }
    }

    @VisibleForTesting
    void doPopulateProject(@NotNull DataNode<ProjectData> projectInfo, @NotNull Project project, @Nullable PostSyncProjectSetup.Request setupRequest) {
        try {
            this.myDataManager.importData(projectInfo, project, true);
        }
        catch (Throwable unexpected) {
            String message2 = Strings.nullToEmpty((String)ExceptionUtil.getRootCause((Throwable)unexpected).getMessage());
            Logger.getInstance(this.getClass()).warn("Sync failed: " + message2, unexpected);
            if (setupRequest != null && setupRequest.usingCachedGradleModels) {
                this.myProjectSetup.onCachedModelsSetupFailure(setupRequest);
                return;
            }
            this.mySyncState.syncFailed(message2);
        }
    }
}

